/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.RunbookAssociationProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class WebhookCreateOrUpdateProperties
implements JsonSerializable<WebhookCreateOrUpdateProperties> {
    private Boolean isEnabled;
    private String uri;
    private OffsetDateTime expiryTime;
    private Map<String, String> parameters;
    private RunbookAssociationProperty runbook;
    private String runOn;

    public Boolean isEnabled() {
        return this.isEnabled;
    }

    public WebhookCreateOrUpdateProperties withIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    public WebhookCreateOrUpdateProperties withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    public WebhookCreateOrUpdateProperties withExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public WebhookCreateOrUpdateProperties withParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public RunbookAssociationProperty runbook() {
        return this.runbook;
    }

    public WebhookCreateOrUpdateProperties withRunbook(RunbookAssociationProperty runbook) {
        this.runbook = runbook;
        return this;
    }

    public String runOn() {
        return this.runOn;
    }

    public WebhookCreateOrUpdateProperties withRunOn(String runOn) {
        this.runOn = runOn;
        return this;
    }

    public void validate() {
        if (this.runbook() != null) {
            this.runbook().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isEnabled", this.isEnabled);
        jsonWriter.writeStringField("uri", this.uri);
        jsonWriter.writeStringField("expiryTime", this.expiryTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiryTime));
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("runbook", (JsonSerializable)this.runbook);
        jsonWriter.writeStringField("runOn", this.runOn);
        return jsonWriter.writeEndObject();
    }

    public static WebhookCreateOrUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WebhookCreateOrUpdateProperties)jsonReader.readObject(reader -> {
            WebhookCreateOrUpdateProperties deserializedWebhookCreateOrUpdateProperties = new WebhookCreateOrUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("isEnabled".equals(fieldName)) {
                    deserializedWebhookCreateOrUpdateProperties.isEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("uri".equals(fieldName)) {
                    deserializedWebhookCreateOrUpdateProperties.uri = reader.getString();
                    continue;
                }
                if ("expiryTime".equals(fieldName)) {
                    deserializedWebhookCreateOrUpdateProperties.expiryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedWebhookCreateOrUpdateProperties.parameters = parameters = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("runbook".equals(fieldName)) {
                    deserializedWebhookCreateOrUpdateProperties.runbook = RunbookAssociationProperty.fromJson(reader);
                    continue;
                }
                if ("runOn".equals(fieldName)) {
                    deserializedWebhookCreateOrUpdateProperties.runOn = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebhookCreateOrUpdateProperties;
        });
    }
}

