/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.WebhookProperties;
import com.azure.resourcemanager.automation.models.RunbookAssociationProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class WebhookInner
extends ProxyResource {
    private WebhookProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private WebhookProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public Boolean isEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isEnabled();
    }

    public WebhookInner withIsEnabled(Boolean isEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookProperties();
        }
        this.innerProperties().withIsEnabled(isEnabled);
        return this;
    }

    public String uri() {
        return this.innerProperties() == null ? null : this.innerProperties().uri();
    }

    public WebhookInner withUri(String uri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookProperties();
        }
        this.innerProperties().withUri(uri);
        return this;
    }

    public OffsetDateTime expiryTime() {
        return this.innerProperties() == null ? null : this.innerProperties().expiryTime();
    }

    public WebhookInner withExpiryTime(OffsetDateTime expiryTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookProperties();
        }
        this.innerProperties().withExpiryTime(expiryTime);
        return this;
    }

    public OffsetDateTime lastInvokedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastInvokedTime();
    }

    public WebhookInner withLastInvokedTime(OffsetDateTime lastInvokedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookProperties();
        }
        this.innerProperties().withLastInvokedTime(lastInvokedTime);
        return this;
    }

    public Map<String, String> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public WebhookInner withParameters(Map<String, String> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public RunbookAssociationProperty runbook() {
        return this.innerProperties() == null ? null : this.innerProperties().runbook();
    }

    public WebhookInner withRunbook(RunbookAssociationProperty runbook) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookProperties();
        }
        this.innerProperties().withRunbook(runbook);
        return this;
    }

    public String runOn() {
        return this.innerProperties() == null ? null : this.innerProperties().runOn();
    }

    public WebhookInner withRunOn(String runOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookProperties();
        }
        this.innerProperties().withRunOn(runOn);
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public WebhookInner withCreationTime(OffsetDateTime creationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookProperties();
        }
        this.innerProperties().withCreationTime(creationTime);
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public WebhookInner withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookProperties();
        }
        this.innerProperties().withLastModifiedTime(lastModifiedTime);
        return this;
    }

    public String lastModifiedBy() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedBy();
    }

    public WebhookInner withLastModifiedBy(String lastModifiedBy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookProperties();
        }
        this.innerProperties().withLastModifiedBy(lastModifiedBy);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public WebhookInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static WebhookInner fromJson(JsonReader jsonReader) throws IOException {
        return (WebhookInner)((Object)jsonReader.readObject(reader -> {
            WebhookInner deserializedWebhookInner = new WebhookInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWebhookInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWebhookInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWebhookInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWebhookInner.innerProperties = WebhookProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebhookInner;
        }));
    }
}

