/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.RunbookAssociationProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class WebhookProperties
implements JsonSerializable<WebhookProperties> {
    private Boolean isEnabled;
    private String uri;
    private OffsetDateTime expiryTime;
    private OffsetDateTime lastInvokedTime;
    private Map<String, String> parameters;
    private RunbookAssociationProperty runbook;
    private String runOn;
    private OffsetDateTime creationTime;
    private OffsetDateTime lastModifiedTime;
    private String lastModifiedBy;
    private String description;

    public Boolean isEnabled() {
        return this.isEnabled;
    }

    public WebhookProperties withIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    public WebhookProperties withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    public WebhookProperties withExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public OffsetDateTime lastInvokedTime() {
        return this.lastInvokedTime;
    }

    public WebhookProperties withLastInvokedTime(OffsetDateTime lastInvokedTime) {
        this.lastInvokedTime = lastInvokedTime;
        return this;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public WebhookProperties withParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public RunbookAssociationProperty runbook() {
        return this.runbook;
    }

    public WebhookProperties withRunbook(RunbookAssociationProperty runbook) {
        this.runbook = runbook;
        return this;
    }

    public String runOn() {
        return this.runOn;
    }

    public WebhookProperties withRunOn(String runOn) {
        this.runOn = runOn;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public WebhookProperties withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public WebhookProperties withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public WebhookProperties withLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    public String description() {
        return this.description;
    }

    public WebhookProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.runbook() != null) {
            this.runbook().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isEnabled", this.isEnabled);
        jsonWriter.writeStringField("uri", this.uri);
        jsonWriter.writeStringField("expiryTime", this.expiryTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiryTime));
        jsonWriter.writeStringField("lastInvokedTime", this.lastInvokedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastInvokedTime));
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("runbook", (JsonSerializable)this.runbook);
        jsonWriter.writeStringField("runOn", this.runOn);
        jsonWriter.writeStringField("creationTime", this.creationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTime));
        jsonWriter.writeStringField("lastModifiedTime", this.lastModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedTime));
        jsonWriter.writeStringField("lastModifiedBy", this.lastModifiedBy);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static WebhookProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WebhookProperties)jsonReader.readObject(reader -> {
            WebhookProperties deserializedWebhookProperties = new WebhookProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("isEnabled".equals(fieldName)) {
                    deserializedWebhookProperties.isEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("uri".equals(fieldName)) {
                    deserializedWebhookProperties.uri = reader.getString();
                    continue;
                }
                if ("expiryTime".equals(fieldName)) {
                    deserializedWebhookProperties.expiryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastInvokedTime".equals(fieldName)) {
                    deserializedWebhookProperties.lastInvokedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedWebhookProperties.parameters = parameters = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("runbook".equals(fieldName)) {
                    deserializedWebhookProperties.runbook = RunbookAssociationProperty.fromJson(reader);
                    continue;
                }
                if ("runOn".equals(fieldName)) {
                    deserializedWebhookProperties.runOn = reader.getString();
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedWebhookProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedWebhookProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedWebhookProperties.lastModifiedBy = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedWebhookProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebhookProperties;
        });
    }
}

