/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.ActivitiesClient;
import com.azure.resourcemanager.automation.fluent.models.ActivityInner;
import com.azure.resourcemanager.automation.implementation.ActivityImpl;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.Activities;
import com.azure.resourcemanager.automation.models.Activity;

public final class ActivitiesImpl
implements Activities {
    private static final ClientLogger LOGGER = new ClientLogger(ActivitiesImpl.class);
    private final ActivitiesClient innerClient;
    private final AutomationManager serviceManager;

    public ActivitiesImpl(ActivitiesClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Activity> getWithResponse(String resourceGroupName, String automationAccountName, String moduleName, String activityName, Context context) {
        Response<ActivityInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, moduleName, activityName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ActivityImpl((ActivityInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public Activity get(String resourceGroupName, String automationAccountName, String moduleName, String activityName) {
        ActivityInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, moduleName, activityName);
        if (inner != null) {
            return new ActivityImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Activity> listByModule(String resourceGroupName, String automationAccountName, String moduleName) {
        PagedIterable<ActivityInner> inner = this.serviceClient().listByModule(resourceGroupName, automationAccountName, moduleName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ActivityImpl((ActivityInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<Activity> listByModule(String resourceGroupName, String automationAccountName, String moduleName, Context context) {
        PagedIterable<ActivityInner> inner = this.serviceClient().listByModule(resourceGroupName, automationAccountName, moduleName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ActivityImpl((ActivityInner)inner1, this.manager()));
    }

    private ActivitiesClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }
}

