/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.AgentRegistrationInformationsClient;
import com.azure.resourcemanager.automation.fluent.models.AgentRegistrationInner;
import com.azure.resourcemanager.automation.implementation.AgentRegistrationImpl;
import com.azure.resourcemanager.automation.models.AgentRegistration;
import com.azure.resourcemanager.automation.models.AgentRegistrationInformations;
import com.azure.resourcemanager.automation.models.AgentRegistrationRegenerateKeyParameter;

public final class AgentRegistrationInformationsImpl
implements AgentRegistrationInformations {
    private static final ClientLogger LOGGER = new ClientLogger(AgentRegistrationInformationsImpl.class);
    private final AgentRegistrationInformationsClient innerClient;
    private final AutomationManager serviceManager;

    public AgentRegistrationInformationsImpl(AgentRegistrationInformationsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<AgentRegistration> getWithResponse(String resourceGroupName, String automationAccountName, Context context) {
        Response<AgentRegistrationInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AgentRegistrationImpl((AgentRegistrationInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public AgentRegistration get(String resourceGroupName, String automationAccountName) {
        AgentRegistrationInner inner = this.serviceClient().get(resourceGroupName, automationAccountName);
        if (inner != null) {
            return new AgentRegistrationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<AgentRegistration> regenerateKeyWithResponse(String resourceGroupName, String automationAccountName, AgentRegistrationRegenerateKeyParameter parameters, Context context) {
        Response<AgentRegistrationInner> inner = this.serviceClient().regenerateKeyWithResponse(resourceGroupName, automationAccountName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AgentRegistrationImpl((AgentRegistrationInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public AgentRegistration regenerateKey(String resourceGroupName, String automationAccountName, AgentRegistrationRegenerateKeyParameter parameters) {
        AgentRegistrationInner inner = this.serviceClient().regenerateKey(resourceGroupName, automationAccountName, parameters);
        if (inner != null) {
            return new AgentRegistrationImpl(inner, this.manager());
        }
        return null;
    }

    private AgentRegistrationInformationsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }
}

