/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.AutomationAccountInner;
import com.azure.resourcemanager.automation.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.automation.implementation.PrivateEndpointConnectionImpl;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.AutomationAccount;
import com.azure.resourcemanager.automation.models.AutomationAccountCreateOrUpdateParameters;
import com.azure.resourcemanager.automation.models.AutomationAccountState;
import com.azure.resourcemanager.automation.models.AutomationAccountUpdateParameters;
import com.azure.resourcemanager.automation.models.EncryptionProperties;
import com.azure.resourcemanager.automation.models.Identity;
import com.azure.resourcemanager.automation.models.PrivateEndpointConnection;
import com.azure.resourcemanager.automation.models.Sku;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class AutomationAccountImpl
implements AutomationAccount,
AutomationAccount.Definition,
AutomationAccount.Update {
    private AutomationAccountInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private AutomationAccountCreateOrUpdateParameters createParameters;
    private AutomationAccountUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public Identity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Sku sku() {
        return this.innerModel().sku();
    }

    @Override
    public String lastModifiedBy() {
        return this.innerModel().lastModifiedBy();
    }

    @Override
    public AutomationAccountState state() {
        return this.innerModel().state();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.innerModel().lastModifiedTime();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public EncryptionProperties encryption() {
        return this.innerModel().encryption();
    }

    @Override
    public List<PrivateEndpointConnection> privateEndpointConnections() {
        List<PrivateEndpointConnectionInner> inner = this.innerModel().privateEndpointConnections();
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner1), this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean publicNetworkAccess() {
        return this.innerModel().publicNetworkAccess();
    }

    @Override
    public Boolean disableLocalAuth() {
        return this.innerModel().disableLocalAuth();
    }

    @Override
    public String automationHybridServiceUrl() {
        return this.innerModel().automationHybridServiceUrl();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AutomationAccountInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public AutomationAccountImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public AutomationAccount create() {
        this.innerObject = (AutomationAccountInner)((Object)this.serviceManager.serviceClient().getAutomationAccounts().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.createParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public AutomationAccount create(Context context) {
        this.innerObject = (AutomationAccountInner)((Object)this.serviceManager.serviceClient().getAutomationAccounts().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.createParameters, context).getValue());
        return this;
    }

    AutomationAccountImpl(String name, AutomationManager serviceManager) {
        this.innerObject = new AutomationAccountInner();
        this.serviceManager = serviceManager;
        this.automationAccountName = name;
        this.createParameters = new AutomationAccountCreateOrUpdateParameters();
    }

    @Override
    public AutomationAccountImpl update() {
        this.updateParameters = new AutomationAccountUpdateParameters();
        return this;
    }

    @Override
    public AutomationAccount apply() {
        this.innerObject = (AutomationAccountInner)((Object)this.serviceManager.serviceClient().getAutomationAccounts().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.updateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public AutomationAccount apply(Context context) {
        this.innerObject = (AutomationAccountInner)((Object)this.serviceManager.serviceClient().getAutomationAccounts().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.updateParameters, context).getValue());
        return this;
    }

    AutomationAccountImpl(AutomationAccountInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.automationAccountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "automationAccounts");
    }

    @Override
    public AutomationAccount refresh() {
        this.innerObject = (AutomationAccountInner)((Object)this.serviceManager.serviceClient().getAutomationAccounts().getByResourceGroupWithResponse(this.resourceGroupName, this.automationAccountName, Context.NONE).getValue());
        return this;
    }

    @Override
    public AutomationAccount refresh(Context context) {
        this.innerObject = (AutomationAccountInner)((Object)this.serviceManager.serviceClient().getAutomationAccounts().getByResourceGroupWithResponse(this.resourceGroupName, this.automationAccountName, context).getValue());
        return this;
    }

    @Override
    public AutomationAccountImpl withRegion(Region location) {
        this.createParameters.withLocation(location.toString());
        return this;
    }

    @Override
    public AutomationAccountImpl withRegion(String location) {
        this.createParameters.withLocation(location);
        return this;
    }

    @Override
    public AutomationAccountImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.createParameters.withTags(tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public AutomationAccountImpl withName(String name) {
        if (this.isInCreateMode()) {
            this.createParameters.withName(name);
            return this;
        }
        this.updateParameters.withName(name);
        return this;
    }

    @Override
    public AutomationAccountImpl withIdentity(Identity identity) {
        if (this.isInCreateMode()) {
            this.createParameters.withIdentity(identity);
            return this;
        }
        this.updateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public AutomationAccountImpl withSku(Sku sku) {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(sku);
            return this;
        }
        this.updateParameters.withSku(sku);
        return this;
    }

    @Override
    public AutomationAccountImpl withEncryption(EncryptionProperties encryption) {
        if (this.isInCreateMode()) {
            this.createParameters.withEncryption(encryption);
            return this;
        }
        this.updateParameters.withEncryption(encryption);
        return this;
    }

    @Override
    public AutomationAccountImpl withPublicNetworkAccess(Boolean publicNetworkAccess) {
        if (this.isInCreateMode()) {
            this.createParameters.withPublicNetworkAccess(publicNetworkAccess);
            return this;
        }
        this.updateParameters.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public AutomationAccountImpl withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.isInCreateMode()) {
            this.createParameters.withDisableLocalAuth(disableLocalAuth);
            return this;
        }
        this.updateParameters.withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

