/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.AutomationAccountsClient;
import com.azure.resourcemanager.automation.fluent.models.AutomationAccountInner;
import com.azure.resourcemanager.automation.implementation.AutomationAccountImpl;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.AutomationAccount;
import com.azure.resourcemanager.automation.models.AutomationAccounts;

public final class AutomationAccountsImpl
implements AutomationAccounts {
    private static final ClientLogger LOGGER = new ClientLogger(AutomationAccountsImpl.class);
    private final AutomationAccountsClient innerClient;
    private final AutomationManager serviceManager;

    public AutomationAccountsImpl(AutomationAccountsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String resourceGroupName, String automationAccountName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, automationAccountName, context);
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String automationAccountName) {
        this.serviceClient().delete(resourceGroupName, automationAccountName);
    }

    @Override
    public Response<AutomationAccount> getByResourceGroupWithResponse(String resourceGroupName, String automationAccountName, Context context) {
        Response<AutomationAccountInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, automationAccountName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AutomationAccountImpl((AutomationAccountInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AutomationAccount getByResourceGroup(String resourceGroupName, String automationAccountName) {
        AutomationAccountInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, automationAccountName);
        if (inner != null) {
            return new AutomationAccountImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<AutomationAccount> listByResourceGroup(String resourceGroupName) {
        PagedIterable<AutomationAccountInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AutomationAccountImpl((AutomationAccountInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AutomationAccount> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<AutomationAccountInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AutomationAccountImpl((AutomationAccountInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AutomationAccount> list() {
        PagedIterable<AutomationAccountInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AutomationAccountImpl((AutomationAccountInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AutomationAccount> list(Context context) {
        PagedIterable<AutomationAccountInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AutomationAccountImpl((AutomationAccountInner)((Object)inner1), this.manager()));
    }

    @Override
    public AutomationAccount getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        return (AutomationAccount)this.getByResourceGroupWithResponse(resourceGroupName, automationAccountName, Context.NONE).getValue();
    }

    @Override
    public Response<AutomationAccount> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, automationAccountName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        this.deleteByResourceGroupWithResponse(resourceGroupName, automationAccountName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(resourceGroupName, automationAccountName, context);
    }

    private AutomationAccountsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public AutomationAccountImpl define(String name) {
        return new AutomationAccountImpl(name, this.manager());
    }
}

