/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.automation.fluent.ActivitiesClient;
import com.azure.resourcemanager.automation.fluent.AgentRegistrationInformationsClient;
import com.azure.resourcemanager.automation.fluent.AutomationAccountsClient;
import com.azure.resourcemanager.automation.fluent.AutomationClient;
import com.azure.resourcemanager.automation.fluent.CertificatesClient;
import com.azure.resourcemanager.automation.fluent.ConnectionTypesClient;
import com.azure.resourcemanager.automation.fluent.ConnectionsClient;
import com.azure.resourcemanager.automation.fluent.CredentialsClient;
import com.azure.resourcemanager.automation.fluent.DeletedAutomationAccountsClient;
import com.azure.resourcemanager.automation.fluent.DscCompilationJobStreamsClient;
import com.azure.resourcemanager.automation.fluent.DscCompilationJobsClient;
import com.azure.resourcemanager.automation.fluent.DscConfigurationsClient;
import com.azure.resourcemanager.automation.fluent.DscNodeConfigurationsClient;
import com.azure.resourcemanager.automation.fluent.DscNodesClient;
import com.azure.resourcemanager.automation.fluent.FieldsClient;
import com.azure.resourcemanager.automation.fluent.HybridRunbookWorkerGroupsClient;
import com.azure.resourcemanager.automation.fluent.HybridRunbookWorkersClient;
import com.azure.resourcemanager.automation.fluent.JobSchedulesClient;
import com.azure.resourcemanager.automation.fluent.JobStreamsClient;
import com.azure.resourcemanager.automation.fluent.JobsClient;
import com.azure.resourcemanager.automation.fluent.KeysClient;
import com.azure.resourcemanager.automation.fluent.LinkedWorkspacesClient;
import com.azure.resourcemanager.automation.fluent.ModulesClient;
import com.azure.resourcemanager.automation.fluent.NodeCountInformationsClient;
import com.azure.resourcemanager.automation.fluent.NodeReportsClient;
import com.azure.resourcemanager.automation.fluent.ObjectDataTypesClient;
import com.azure.resourcemanager.automation.fluent.OperationsClient;
import com.azure.resourcemanager.automation.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.automation.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.automation.fluent.Python2PackagesClient;
import com.azure.resourcemanager.automation.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.automation.fluent.RunbookDraftsClient;
import com.azure.resourcemanager.automation.fluent.RunbooksClient;
import com.azure.resourcemanager.automation.fluent.SchedulesClient;
import com.azure.resourcemanager.automation.fluent.SoftwareUpdateConfigurationMachineRunsClient;
import com.azure.resourcemanager.automation.fluent.SoftwareUpdateConfigurationRunsClient;
import com.azure.resourcemanager.automation.fluent.SoftwareUpdateConfigurationsClient;
import com.azure.resourcemanager.automation.fluent.SourceControlSyncJobStreamsClient;
import com.azure.resourcemanager.automation.fluent.SourceControlSyncJobsClient;
import com.azure.resourcemanager.automation.fluent.SourceControlsClient;
import com.azure.resourcemanager.automation.fluent.StatisticsOperationsClient;
import com.azure.resourcemanager.automation.fluent.TestJobStreamsClient;
import com.azure.resourcemanager.automation.fluent.TestJobsClient;
import com.azure.resourcemanager.automation.fluent.UsagesClient;
import com.azure.resourcemanager.automation.fluent.VariablesClient;
import com.azure.resourcemanager.automation.fluent.WatchersClient;
import com.azure.resourcemanager.automation.fluent.WebhooksClient;
import com.azure.resourcemanager.automation.implementation.ActivitiesClientImpl;
import com.azure.resourcemanager.automation.implementation.AgentRegistrationInformationsClientImpl;
import com.azure.resourcemanager.automation.implementation.AutomationAccountsClientImpl;
import com.azure.resourcemanager.automation.implementation.AutomationClientBuilder;
import com.azure.resourcemanager.automation.implementation.CertificatesClientImpl;
import com.azure.resourcemanager.automation.implementation.ConnectionTypesClientImpl;
import com.azure.resourcemanager.automation.implementation.ConnectionsClientImpl;
import com.azure.resourcemanager.automation.implementation.CredentialsClientImpl;
import com.azure.resourcemanager.automation.implementation.DeletedAutomationAccountsClientImpl;
import com.azure.resourcemanager.automation.implementation.DscCompilationJobStreamsClientImpl;
import com.azure.resourcemanager.automation.implementation.DscCompilationJobsClientImpl;
import com.azure.resourcemanager.automation.implementation.DscConfigurationsClientImpl;
import com.azure.resourcemanager.automation.implementation.DscNodeConfigurationsClientImpl;
import com.azure.resourcemanager.automation.implementation.DscNodesClientImpl;
import com.azure.resourcemanager.automation.implementation.FieldsClientImpl;
import com.azure.resourcemanager.automation.implementation.HybridRunbookWorkerGroupsClientImpl;
import com.azure.resourcemanager.automation.implementation.HybridRunbookWorkersClientImpl;
import com.azure.resourcemanager.automation.implementation.JobSchedulesClientImpl;
import com.azure.resourcemanager.automation.implementation.JobStreamsClientImpl;
import com.azure.resourcemanager.automation.implementation.JobsClientImpl;
import com.azure.resourcemanager.automation.implementation.KeysClientImpl;
import com.azure.resourcemanager.automation.implementation.LinkedWorkspacesClientImpl;
import com.azure.resourcemanager.automation.implementation.ModulesClientImpl;
import com.azure.resourcemanager.automation.implementation.NodeCountInformationsClientImpl;
import com.azure.resourcemanager.automation.implementation.NodeReportsClientImpl;
import com.azure.resourcemanager.automation.implementation.ObjectDataTypesClientImpl;
import com.azure.resourcemanager.automation.implementation.OperationsClientImpl;
import com.azure.resourcemanager.automation.implementation.PrivateEndpointConnectionsClientImpl;
import com.azure.resourcemanager.automation.implementation.PrivateLinkResourcesClientImpl;
import com.azure.resourcemanager.automation.implementation.Python2PackagesClientImpl;
import com.azure.resourcemanager.automation.implementation.ResourceProvidersClientImpl;
import com.azure.resourcemanager.automation.implementation.RunbookDraftsClientImpl;
import com.azure.resourcemanager.automation.implementation.RunbooksClientImpl;
import com.azure.resourcemanager.automation.implementation.SchedulesClientImpl;
import com.azure.resourcemanager.automation.implementation.SoftwareUpdateConfigurationMachineRunsClientImpl;
import com.azure.resourcemanager.automation.implementation.SoftwareUpdateConfigurationRunsClientImpl;
import com.azure.resourcemanager.automation.implementation.SoftwareUpdateConfigurationsClientImpl;
import com.azure.resourcemanager.automation.implementation.SourceControlSyncJobStreamsClientImpl;
import com.azure.resourcemanager.automation.implementation.SourceControlSyncJobsClientImpl;
import com.azure.resourcemanager.automation.implementation.SourceControlsClientImpl;
import com.azure.resourcemanager.automation.implementation.StatisticsOperationsClientImpl;
import com.azure.resourcemanager.automation.implementation.TestJobStreamsClientImpl;
import com.azure.resourcemanager.automation.implementation.TestJobsClientImpl;
import com.azure.resourcemanager.automation.implementation.UsagesClientImpl;
import com.azure.resourcemanager.automation.implementation.VariablesClientImpl;
import com.azure.resourcemanager.automation.implementation.WatchersClientImpl;
import com.azure.resourcemanager.automation.implementation.WebhooksClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=AutomationClientBuilder.class)
public final class AutomationClientImpl
implements AutomationClient {
    private final String subscriptionId;
    private final String endpoint;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final PrivateEndpointConnectionsClient privateEndpointConnections;
    private final PrivateLinkResourcesClient privateLinkResources;
    private final Python2PackagesClient python2Packages;
    private final AgentRegistrationInformationsClient agentRegistrationInformations;
    private final DscNodesClient dscNodes;
    private final NodeReportsClient nodeReports;
    private final DscNodeConfigurationsClient dscNodeConfigurations;
    private final DscCompilationJobsClient dscCompilationJobs;
    private final DscCompilationJobStreamsClient dscCompilationJobStreams;
    private final NodeCountInformationsClient nodeCountInformations;
    private final SourceControlsClient sourceControls;
    private final SourceControlSyncJobsClient sourceControlSyncJobs;
    private final SourceControlSyncJobStreamsClient sourceControlSyncJobStreams;
    private final AutomationAccountsClient automationAccounts;
    private final StatisticsOperationsClient statisticsOperations;
    private final UsagesClient usages;
    private final KeysClient keys;
    private final CertificatesClient certificates;
    private final ConnectionsClient connections;
    private final ConnectionTypesClient connectionTypes;
    private final CredentialsClient credentials;
    private final JobSchedulesClient jobSchedules;
    private final LinkedWorkspacesClient linkedWorkspaces;
    private final ActivitiesClient activities;
    private final ModulesClient modules;
    private final ObjectDataTypesClient objectDataTypes;
    private final FieldsClient fields;
    private final SchedulesClient schedules;
    private final VariablesClient variables;
    private final WatchersClient watchers;
    private final DscConfigurationsClient dscConfigurations;
    private final JobsClient jobs;
    private final JobStreamsClient jobStreams;
    private final OperationsClient operations;
    private final ResourceProvidersClient resourceProviders;
    private final SoftwareUpdateConfigurationsClient softwareUpdateConfigurations;
    private final SoftwareUpdateConfigurationRunsClient softwareUpdateConfigurationRuns;
    private final SoftwareUpdateConfigurationMachineRunsClient softwareUpdateConfigurationMachineRuns;
    private final RunbookDraftsClient runbookDrafts;
    private final RunbooksClient runbooks;
    private final TestJobStreamsClient testJobStreams;
    private final TestJobsClient testJobs;
    private final WebhooksClient webhooks;
    private final HybridRunbookWorkersClient hybridRunbookWorkers;
    private final DeletedAutomationAccountsClient deletedAutomationAccounts;
    private final HybridRunbookWorkerGroupsClient hybridRunbookWorkerGroups;
    private static final ClientLogger LOGGER = new ClientLogger(AutomationClientImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public PrivateEndpointConnectionsClient getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    @Override
    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    @Override
    public Python2PackagesClient getPython2Packages() {
        return this.python2Packages;
    }

    @Override
    public AgentRegistrationInformationsClient getAgentRegistrationInformations() {
        return this.agentRegistrationInformations;
    }

    @Override
    public DscNodesClient getDscNodes() {
        return this.dscNodes;
    }

    @Override
    public NodeReportsClient getNodeReports() {
        return this.nodeReports;
    }

    @Override
    public DscNodeConfigurationsClient getDscNodeConfigurations() {
        return this.dscNodeConfigurations;
    }

    @Override
    public DscCompilationJobsClient getDscCompilationJobs() {
        return this.dscCompilationJobs;
    }

    @Override
    public DscCompilationJobStreamsClient getDscCompilationJobStreams() {
        return this.dscCompilationJobStreams;
    }

    @Override
    public NodeCountInformationsClient getNodeCountInformations() {
        return this.nodeCountInformations;
    }

    @Override
    public SourceControlsClient getSourceControls() {
        return this.sourceControls;
    }

    @Override
    public SourceControlSyncJobsClient getSourceControlSyncJobs() {
        return this.sourceControlSyncJobs;
    }

    @Override
    public SourceControlSyncJobStreamsClient getSourceControlSyncJobStreams() {
        return this.sourceControlSyncJobStreams;
    }

    @Override
    public AutomationAccountsClient getAutomationAccounts() {
        return this.automationAccounts;
    }

    @Override
    public StatisticsOperationsClient getStatisticsOperations() {
        return this.statisticsOperations;
    }

    @Override
    public UsagesClient getUsages() {
        return this.usages;
    }

    @Override
    public KeysClient getKeys() {
        return this.keys;
    }

    @Override
    public CertificatesClient getCertificates() {
        return this.certificates;
    }

    @Override
    public ConnectionsClient getConnections() {
        return this.connections;
    }

    @Override
    public ConnectionTypesClient getConnectionTypes() {
        return this.connectionTypes;
    }

    @Override
    public CredentialsClient getCredentials() {
        return this.credentials;
    }

    @Override
    public JobSchedulesClient getJobSchedules() {
        return this.jobSchedules;
    }

    @Override
    public LinkedWorkspacesClient getLinkedWorkspaces() {
        return this.linkedWorkspaces;
    }

    @Override
    public ActivitiesClient getActivities() {
        return this.activities;
    }

    @Override
    public ModulesClient getModules() {
        return this.modules;
    }

    @Override
    public ObjectDataTypesClient getObjectDataTypes() {
        return this.objectDataTypes;
    }

    @Override
    public FieldsClient getFields() {
        return this.fields;
    }

    @Override
    public SchedulesClient getSchedules() {
        return this.schedules;
    }

    @Override
    public VariablesClient getVariables() {
        return this.variables;
    }

    @Override
    public WatchersClient getWatchers() {
        return this.watchers;
    }

    @Override
    public DscConfigurationsClient getDscConfigurations() {
        return this.dscConfigurations;
    }

    @Override
    public JobsClient getJobs() {
        return this.jobs;
    }

    @Override
    public JobStreamsClient getJobStreams() {
        return this.jobStreams;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public ResourceProvidersClient getResourceProviders() {
        return this.resourceProviders;
    }

    @Override
    public SoftwareUpdateConfigurationsClient getSoftwareUpdateConfigurations() {
        return this.softwareUpdateConfigurations;
    }

    @Override
    public SoftwareUpdateConfigurationRunsClient getSoftwareUpdateConfigurationRuns() {
        return this.softwareUpdateConfigurationRuns;
    }

    @Override
    public SoftwareUpdateConfigurationMachineRunsClient getSoftwareUpdateConfigurationMachineRuns() {
        return this.softwareUpdateConfigurationMachineRuns;
    }

    @Override
    public RunbookDraftsClient getRunbookDrafts() {
        return this.runbookDrafts;
    }

    @Override
    public RunbooksClient getRunbooks() {
        return this.runbooks;
    }

    @Override
    public TestJobStreamsClient getTestJobStreams() {
        return this.testJobStreams;
    }

    @Override
    public TestJobsClient getTestJobs() {
        return this.testJobs;
    }

    @Override
    public WebhooksClient getWebhooks() {
        return this.webhooks;
    }

    @Override
    public HybridRunbookWorkersClient getHybridRunbookWorkers() {
        return this.hybridRunbookWorkers;
    }

    @Override
    public DeletedAutomationAccountsClient getDeletedAutomationAccounts() {
        return this.deletedAutomationAccounts;
    }

    @Override
    public HybridRunbookWorkerGroupsClient getHybridRunbookWorkerGroups() {
        return this.hybridRunbookWorkerGroups;
    }

    AutomationClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.privateEndpointConnections = new PrivateEndpointConnectionsClientImpl(this);
        this.privateLinkResources = new PrivateLinkResourcesClientImpl(this);
        this.python2Packages = new Python2PackagesClientImpl(this);
        this.agentRegistrationInformations = new AgentRegistrationInformationsClientImpl(this);
        this.dscNodes = new DscNodesClientImpl(this);
        this.nodeReports = new NodeReportsClientImpl(this);
        this.dscNodeConfigurations = new DscNodeConfigurationsClientImpl(this);
        this.dscCompilationJobs = new DscCompilationJobsClientImpl(this);
        this.dscCompilationJobStreams = new DscCompilationJobStreamsClientImpl(this);
        this.nodeCountInformations = new NodeCountInformationsClientImpl(this);
        this.sourceControls = new SourceControlsClientImpl(this);
        this.sourceControlSyncJobs = new SourceControlSyncJobsClientImpl(this);
        this.sourceControlSyncJobStreams = new SourceControlSyncJobStreamsClientImpl(this);
        this.automationAccounts = new AutomationAccountsClientImpl(this);
        this.statisticsOperations = new StatisticsOperationsClientImpl(this);
        this.usages = new UsagesClientImpl(this);
        this.keys = new KeysClientImpl(this);
        this.certificates = new CertificatesClientImpl(this);
        this.connections = new ConnectionsClientImpl(this);
        this.connectionTypes = new ConnectionTypesClientImpl(this);
        this.credentials = new CredentialsClientImpl(this);
        this.jobSchedules = new JobSchedulesClientImpl(this);
        this.linkedWorkspaces = new LinkedWorkspacesClientImpl(this);
        this.activities = new ActivitiesClientImpl(this);
        this.modules = new ModulesClientImpl(this);
        this.objectDataTypes = new ObjectDataTypesClientImpl(this);
        this.fields = new FieldsClientImpl(this);
        this.schedules = new SchedulesClientImpl(this);
        this.variables = new VariablesClientImpl(this);
        this.watchers = new WatchersClientImpl(this);
        this.dscConfigurations = new DscConfigurationsClientImpl(this);
        this.jobs = new JobsClientImpl(this);
        this.jobStreams = new JobStreamsClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.resourceProviders = new ResourceProvidersClientImpl(this);
        this.softwareUpdateConfigurations = new SoftwareUpdateConfigurationsClientImpl(this);
        this.softwareUpdateConfigurationRuns = new SoftwareUpdateConfigurationRunsClientImpl(this);
        this.softwareUpdateConfigurationMachineRuns = new SoftwareUpdateConfigurationMachineRunsClientImpl(this);
        this.runbookDrafts = new RunbookDraftsClientImpl(this);
        this.runbooks = new RunbooksClientImpl(this);
        this.testJobStreams = new TestJobStreamsClientImpl(this);
        this.testJobs = new TestJobsClientImpl(this);
        this.webhooks = new WebhooksClientImpl(this);
        this.hybridRunbookWorkers = new HybridRunbookWorkersClientImpl(this);
        this.deletedAutomationAccounts = new DeletedAutomationAccountsClientImpl(this);
        this.hybridRunbookWorkerGroups = new HybridRunbookWorkerGroupsClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

