/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.CertificateInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.Certificate;
import com.azure.resourcemanager.automation.models.CertificateCreateOrUpdateParameters;
import com.azure.resourcemanager.automation.models.CertificateUpdateParameters;
import java.time.OffsetDateTime;

public final class CertificateImpl
implements Certificate,
Certificate.Definition,
Certificate.Update {
    private CertificateInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private String certificateName;
    private CertificateCreateOrUpdateParameters createParameters;
    private CertificateUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String thumbprint() {
        return this.innerModel().thumbprint();
    }

    @Override
    public OffsetDateTime expiryTime() {
        return this.innerModel().expiryTime();
    }

    @Override
    public Boolean isExportable() {
        return this.innerModel().isExportable();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.innerModel().lastModifiedTime();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public CertificateInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public CertificateImpl withExistingAutomationAccount(String resourceGroupName, String automationAccountName) {
        this.resourceGroupName = resourceGroupName;
        this.automationAccountName = automationAccountName;
        return this;
    }

    @Override
    public Certificate create() {
        this.innerObject = (CertificateInner)((Object)this.serviceManager.serviceClient().getCertificates().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.certificateName, this.createParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Certificate create(Context context) {
        this.innerObject = (CertificateInner)((Object)this.serviceManager.serviceClient().getCertificates().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.certificateName, this.createParameters, context).getValue());
        return this;
    }

    CertificateImpl(String name, AutomationManager serviceManager) {
        this.innerObject = new CertificateInner();
        this.serviceManager = serviceManager;
        this.certificateName = name;
        this.createParameters = new CertificateCreateOrUpdateParameters();
    }

    @Override
    public CertificateImpl update() {
        this.updateParameters = new CertificateUpdateParameters();
        return this;
    }

    @Override
    public Certificate apply() {
        this.innerObject = (CertificateInner)((Object)this.serviceManager.serviceClient().getCertificates().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.certificateName, this.updateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Certificate apply(Context context) {
        this.innerObject = (CertificateInner)((Object)this.serviceManager.serviceClient().getCertificates().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.certificateName, this.updateParameters, context).getValue());
        return this;
    }

    CertificateImpl(CertificateInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.automationAccountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "automationAccounts");
        this.certificateName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "certificates");
    }

    @Override
    public Certificate refresh() {
        this.innerObject = (CertificateInner)((Object)this.serviceManager.serviceClient().getCertificates().getWithResponse(this.resourceGroupName, this.automationAccountName, this.certificateName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Certificate refresh(Context context) {
        this.innerObject = (CertificateInner)((Object)this.serviceManager.serviceClient().getCertificates().getWithResponse(this.resourceGroupName, this.automationAccountName, this.certificateName, context).getValue());
        return this;
    }

    @Override
    public CertificateImpl withName(String name) {
        if (this.isInCreateMode()) {
            this.createParameters.withName(name);
            return this;
        }
        this.updateParameters.withName(name);
        return this;
    }

    @Override
    public CertificateImpl withBase64Value(String base64Value) {
        this.createParameters.withBase64Value(base64Value);
        return this;
    }

    @Override
    public CertificateImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.createParameters.withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    @Override
    public CertificateImpl withThumbprint(String thumbprint) {
        this.createParameters.withThumbprint(thumbprint);
        return this;
    }

    @Override
    public CertificateImpl withIsExportable(Boolean isExportable) {
        this.createParameters.withIsExportable(isExportable);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

