/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.CertificatesClient;
import com.azure.resourcemanager.automation.fluent.models.CertificateInner;
import com.azure.resourcemanager.automation.implementation.CertificateImpl;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.Certificate;
import com.azure.resourcemanager.automation.models.Certificates;

public final class CertificatesImpl
implements Certificates {
    private static final ClientLogger LOGGER = new ClientLogger(CertificatesImpl.class);
    private final CertificatesClient innerClient;
    private final AutomationManager serviceManager;

    public CertificatesImpl(CertificatesClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String automationAccountName, String certificateName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, automationAccountName, certificateName, context);
    }

    @Override
    public void delete(String resourceGroupName, String automationAccountName, String certificateName) {
        this.serviceClient().delete(resourceGroupName, automationAccountName, certificateName);
    }

    @Override
    public Response<Certificate> getWithResponse(String resourceGroupName, String automationAccountName, String certificateName, Context context) {
        Response<CertificateInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, certificateName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CertificateImpl((CertificateInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Certificate get(String resourceGroupName, String automationAccountName, String certificateName) {
        CertificateInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, certificateName);
        if (inner != null) {
            return new CertificateImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Certificate> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        PagedIterable<CertificateInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CertificateImpl((CertificateInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Certificate> listByAutomationAccount(String resourceGroupName, String automationAccountName, Context context) {
        PagedIterable<CertificateInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CertificateImpl((CertificateInner)((Object)inner1), this.manager()));
    }

    @Override
    public Certificate getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String certificateName = ResourceManagerUtils.getValueFromIdByName(id, "certificates");
        if (certificateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'certificates'.", id)));
        }
        return (Certificate)this.getWithResponse(resourceGroupName, automationAccountName, certificateName, Context.NONE).getValue();
    }

    @Override
    public Response<Certificate> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String certificateName = ResourceManagerUtils.getValueFromIdByName(id, "certificates");
        if (certificateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'certificates'.", id)));
        }
        return this.getWithResponse(resourceGroupName, automationAccountName, certificateName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String certificateName = ResourceManagerUtils.getValueFromIdByName(id, "certificates");
        if (certificateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'certificates'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, automationAccountName, certificateName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String certificateName = ResourceManagerUtils.getValueFromIdByName(id, "certificates");
        if (certificateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'certificates'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, automationAccountName, certificateName, context);
    }

    private CertificatesClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public CertificateImpl define(String name) {
        return new CertificateImpl(name, this.manager());
    }
}

