/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.ConnectionInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.Connection;
import com.azure.resourcemanager.automation.models.ConnectionCreateOrUpdateParameters;
import com.azure.resourcemanager.automation.models.ConnectionTypeAssociationProperty;
import com.azure.resourcemanager.automation.models.ConnectionUpdateParameters;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;

public final class ConnectionImpl
implements Connection,
Connection.Definition,
Connection.Update {
    private ConnectionInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private String connectionName;
    private ConnectionCreateOrUpdateParameters createParameters;
    private ConnectionUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public ConnectionTypeAssociationProperty connectionType() {
        return this.innerModel().connectionType();
    }

    @Override
    public Map<String, String> fieldDefinitionValues() {
        Map<String, String> inner = this.innerModel().fieldDefinitionValues();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.innerModel().lastModifiedTime();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ConnectionInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConnectionImpl withExistingAutomationAccount(String resourceGroupName, String automationAccountName) {
        this.resourceGroupName = resourceGroupName;
        this.automationAccountName = automationAccountName;
        return this;
    }

    @Override
    public Connection create() {
        this.innerObject = (ConnectionInner)((Object)this.serviceManager.serviceClient().getConnections().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.connectionName, this.createParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Connection create(Context context) {
        this.innerObject = (ConnectionInner)((Object)this.serviceManager.serviceClient().getConnections().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.connectionName, this.createParameters, context).getValue());
        return this;
    }

    ConnectionImpl(String name, AutomationManager serviceManager) {
        this.innerObject = new ConnectionInner();
        this.serviceManager = serviceManager;
        this.connectionName = name;
        this.createParameters = new ConnectionCreateOrUpdateParameters();
    }

    @Override
    public ConnectionImpl update() {
        this.updateParameters = new ConnectionUpdateParameters();
        return this;
    }

    @Override
    public Connection apply() {
        this.innerObject = (ConnectionInner)((Object)this.serviceManager.serviceClient().getConnections().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.connectionName, this.updateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Connection apply(Context context) {
        this.innerObject = (ConnectionInner)((Object)this.serviceManager.serviceClient().getConnections().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.connectionName, this.updateParameters, context).getValue());
        return this;
    }

    ConnectionImpl(ConnectionInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.automationAccountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "automationAccounts");
        this.connectionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "connections");
    }

    @Override
    public Connection refresh() {
        this.innerObject = (ConnectionInner)((Object)this.serviceManager.serviceClient().getConnections().getWithResponse(this.resourceGroupName, this.automationAccountName, this.connectionName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Connection refresh(Context context) {
        this.innerObject = (ConnectionInner)((Object)this.serviceManager.serviceClient().getConnections().getWithResponse(this.resourceGroupName, this.automationAccountName, this.connectionName, context).getValue());
        return this;
    }

    @Override
    public ConnectionImpl withName(String name) {
        if (this.isInCreateMode()) {
            this.createParameters.withName(name);
            return this;
        }
        this.updateParameters.withName(name);
        return this;
    }

    @Override
    public ConnectionImpl withConnectionType(ConnectionTypeAssociationProperty connectionType) {
        this.createParameters.withConnectionType(connectionType);
        return this;
    }

    @Override
    public ConnectionImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.createParameters.withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    @Override
    public ConnectionImpl withFieldDefinitionValues(Map<String, String> fieldDefinitionValues) {
        if (this.isInCreateMode()) {
            this.createParameters.withFieldDefinitionValues(fieldDefinitionValues);
            return this;
        }
        this.updateParameters.withFieldDefinitionValues(fieldDefinitionValues);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

