/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.ConnectionTypeInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.ConnectionType;
import com.azure.resourcemanager.automation.models.ConnectionTypeCreateOrUpdateParameters;
import com.azure.resourcemanager.automation.models.FieldDefinition;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;

public final class ConnectionTypeImpl
implements ConnectionType,
ConnectionType.Definition,
ConnectionType.Update {
    private ConnectionTypeInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private String connectionTypeName;
    private ConnectionTypeCreateOrUpdateParameters createParameters;
    private ConnectionTypeCreateOrUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public Boolean isGlobal() {
        return this.innerModel().isGlobal();
    }

    @Override
    public Map<String, FieldDefinition> fieldDefinitions() {
        Map<String, FieldDefinition> inner = this.innerModel().fieldDefinitions();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.innerModel().lastModifiedTime();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ConnectionTypeInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConnectionTypeImpl withExistingAutomationAccount(String resourceGroupName, String automationAccountName) {
        this.resourceGroupName = resourceGroupName;
        this.automationAccountName = automationAccountName;
        return this;
    }

    @Override
    public ConnectionType create() {
        this.innerObject = (ConnectionTypeInner)this.serviceManager.serviceClient().getConnectionTypes().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.connectionTypeName, this.createParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public ConnectionType create(Context context) {
        this.innerObject = (ConnectionTypeInner)this.serviceManager.serviceClient().getConnectionTypes().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.connectionTypeName, this.createParameters, context).getValue();
        return this;
    }

    ConnectionTypeImpl(String name, AutomationManager serviceManager) {
        this.innerObject = new ConnectionTypeInner();
        this.serviceManager = serviceManager;
        this.connectionTypeName = name;
        this.createParameters = new ConnectionTypeCreateOrUpdateParameters();
    }

    @Override
    public ConnectionTypeImpl update() {
        this.updateParameters = new ConnectionTypeCreateOrUpdateParameters();
        return this;
    }

    @Override
    public ConnectionType apply() {
        this.innerObject = (ConnectionTypeInner)this.serviceManager.serviceClient().getConnectionTypes().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.connectionTypeName, this.updateParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public ConnectionType apply(Context context) {
        this.innerObject = (ConnectionTypeInner)this.serviceManager.serviceClient().getConnectionTypes().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.connectionTypeName, this.updateParameters, context).getValue();
        return this;
    }

    ConnectionTypeImpl(ConnectionTypeInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.automationAccountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "automationAccounts");
        this.connectionTypeName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "connectionTypes");
    }

    @Override
    public ConnectionType refresh() {
        this.innerObject = (ConnectionTypeInner)this.serviceManager.serviceClient().getConnectionTypes().getWithResponse(this.resourceGroupName, this.automationAccountName, this.connectionTypeName, Context.NONE).getValue();
        return this;
    }

    @Override
    public ConnectionType refresh(Context context) {
        this.innerObject = (ConnectionTypeInner)this.serviceManager.serviceClient().getConnectionTypes().getWithResponse(this.resourceGroupName, this.automationAccountName, this.connectionTypeName, context).getValue();
        return this;
    }

    @Override
    public ConnectionTypeImpl withName(String name) {
        if (this.isInCreateMode()) {
            this.createParameters.withName(name);
            return this;
        }
        this.updateParameters.withName(name);
        return this;
    }

    @Override
    public ConnectionTypeImpl withFieldDefinitions(Map<String, FieldDefinition> fieldDefinitions) {
        if (this.isInCreateMode()) {
            this.createParameters.withFieldDefinitions(fieldDefinitions);
            return this;
        }
        this.updateParameters.withFieldDefinitions(fieldDefinitions);
        return this;
    }

    @Override
    public ConnectionTypeImpl withIsGlobal(Boolean isGlobal) {
        if (this.isInCreateMode()) {
            this.createParameters.withIsGlobal(isGlobal);
            return this;
        }
        this.updateParameters.withIsGlobal(isGlobal);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

