/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.ConnectionTypesClient;
import com.azure.resourcemanager.automation.fluent.models.ConnectionTypeInner;
import com.azure.resourcemanager.automation.implementation.ConnectionTypeImpl;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.ConnectionType;
import com.azure.resourcemanager.automation.models.ConnectionTypes;

public final class ConnectionTypesImpl
implements ConnectionTypes {
    private static final ClientLogger LOGGER = new ClientLogger(ConnectionTypesImpl.class);
    private final ConnectionTypesClient innerClient;
    private final AutomationManager serviceManager;

    public ConnectionTypesImpl(ConnectionTypesClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String automationAccountName, String connectionTypeName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, automationAccountName, connectionTypeName, context);
    }

    @Override
    public void delete(String resourceGroupName, String automationAccountName, String connectionTypeName) {
        this.serviceClient().delete(resourceGroupName, automationAccountName, connectionTypeName);
    }

    @Override
    public Response<ConnectionType> getWithResponse(String resourceGroupName, String automationAccountName, String connectionTypeName, Context context) {
        Response<ConnectionTypeInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, connectionTypeName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ConnectionTypeImpl((ConnectionTypeInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ConnectionType get(String resourceGroupName, String automationAccountName, String connectionTypeName) {
        ConnectionTypeInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, connectionTypeName);
        if (inner != null) {
            return new ConnectionTypeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<ConnectionType> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        PagedIterable<ConnectionTypeInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConnectionTypeImpl((ConnectionTypeInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ConnectionType> listByAutomationAccount(String resourceGroupName, String automationAccountName, Context context) {
        PagedIterable<ConnectionTypeInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConnectionTypeImpl((ConnectionTypeInner)inner1, this.manager()));
    }

    @Override
    public ConnectionType getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String connectionTypeName = ResourceManagerUtils.getValueFromIdByName(id, "connectionTypes");
        if (connectionTypeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'connectionTypes'.", id)));
        }
        return (ConnectionType)this.getWithResponse(resourceGroupName, automationAccountName, connectionTypeName, Context.NONE).getValue();
    }

    @Override
    public Response<ConnectionType> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String connectionTypeName = ResourceManagerUtils.getValueFromIdByName(id, "connectionTypes");
        if (connectionTypeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'connectionTypes'.", id)));
        }
        return this.getWithResponse(resourceGroupName, automationAccountName, connectionTypeName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String connectionTypeName = ResourceManagerUtils.getValueFromIdByName(id, "connectionTypes");
        if (connectionTypeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'connectionTypes'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, automationAccountName, connectionTypeName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String connectionTypeName = ResourceManagerUtils.getValueFromIdByName(id, "connectionTypes");
        if (connectionTypeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'connectionTypes'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, automationAccountName, connectionTypeName, context);
    }

    private ConnectionTypesClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConnectionTypeImpl define(String name) {
        return new ConnectionTypeImpl(name, this.manager());
    }
}

