/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.CredentialInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.Credential;
import com.azure.resourcemanager.automation.models.CredentialCreateOrUpdateParameters;
import com.azure.resourcemanager.automation.models.CredentialUpdateParameters;
import java.time.OffsetDateTime;

public final class CredentialImpl
implements Credential,
Credential.Definition,
Credential.Update {
    private CredentialInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private String credentialName;
    private CredentialCreateOrUpdateParameters createParameters;
    private CredentialUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String username() {
        return this.innerModel().username();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.innerModel().lastModifiedTime();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public CredentialInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public CredentialImpl withExistingAutomationAccount(String resourceGroupName, String automationAccountName) {
        this.resourceGroupName = resourceGroupName;
        this.automationAccountName = automationAccountName;
        return this;
    }

    @Override
    public Credential create() {
        this.innerObject = (CredentialInner)((Object)this.serviceManager.serviceClient().getCredentials().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.credentialName, this.createParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Credential create(Context context) {
        this.innerObject = (CredentialInner)((Object)this.serviceManager.serviceClient().getCredentials().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.credentialName, this.createParameters, context).getValue());
        return this;
    }

    CredentialImpl(String name, AutomationManager serviceManager) {
        this.innerObject = new CredentialInner();
        this.serviceManager = serviceManager;
        this.credentialName = name;
        this.createParameters = new CredentialCreateOrUpdateParameters();
    }

    @Override
    public CredentialImpl update() {
        this.updateParameters = new CredentialUpdateParameters();
        return this;
    }

    @Override
    public Credential apply() {
        this.innerObject = (CredentialInner)((Object)this.serviceManager.serviceClient().getCredentials().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.credentialName, this.updateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Credential apply(Context context) {
        this.innerObject = (CredentialInner)((Object)this.serviceManager.serviceClient().getCredentials().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.credentialName, this.updateParameters, context).getValue());
        return this;
    }

    CredentialImpl(CredentialInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.automationAccountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "automationAccounts");
        this.credentialName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "credentials");
    }

    @Override
    public Credential refresh() {
        this.innerObject = (CredentialInner)((Object)this.serviceManager.serviceClient().getCredentials().getWithResponse(this.resourceGroupName, this.automationAccountName, this.credentialName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Credential refresh(Context context) {
        this.innerObject = (CredentialInner)((Object)this.serviceManager.serviceClient().getCredentials().getWithResponse(this.resourceGroupName, this.automationAccountName, this.credentialName, context).getValue());
        return this;
    }

    @Override
    public CredentialImpl withName(String name) {
        if (this.isInCreateMode()) {
            this.createParameters.withName(name);
            return this;
        }
        this.updateParameters.withName(name);
        return this;
    }

    @Override
    public CredentialImpl withUsername(String username) {
        if (this.isInCreateMode()) {
            this.createParameters.withUsername(username);
            return this;
        }
        this.updateParameters.withUsername(username);
        return this;
    }

    @Override
    public CredentialImpl withPassword(String password) {
        if (this.isInCreateMode()) {
            this.createParameters.withPassword(password);
            return this;
        }
        this.updateParameters.withPassword(password);
        return this;
    }

    @Override
    public CredentialImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.createParameters.withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

