/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.CredentialsClient;
import com.azure.resourcemanager.automation.fluent.models.CredentialInner;
import com.azure.resourcemanager.automation.implementation.CredentialImpl;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.Credential;
import com.azure.resourcemanager.automation.models.Credentials;

public final class CredentialsImpl
implements Credentials {
    private static final ClientLogger LOGGER = new ClientLogger(CredentialsImpl.class);
    private final CredentialsClient innerClient;
    private final AutomationManager serviceManager;

    public CredentialsImpl(CredentialsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String automationAccountName, String credentialName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, automationAccountName, credentialName, context);
    }

    @Override
    public void delete(String resourceGroupName, String automationAccountName, String credentialName) {
        this.serviceClient().delete(resourceGroupName, automationAccountName, credentialName);
    }

    @Override
    public Response<Credential> getWithResponse(String resourceGroupName, String automationAccountName, String credentialName, Context context) {
        Response<CredentialInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, credentialName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CredentialImpl((CredentialInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Credential get(String resourceGroupName, String automationAccountName, String credentialName) {
        CredentialInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, credentialName);
        if (inner != null) {
            return new CredentialImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Credential> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        PagedIterable<CredentialInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CredentialImpl((CredentialInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Credential> listByAutomationAccount(String resourceGroupName, String automationAccountName, Context context) {
        PagedIterable<CredentialInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CredentialImpl((CredentialInner)((Object)inner1), this.manager()));
    }

    @Override
    public Credential getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String credentialName = ResourceManagerUtils.getValueFromIdByName(id, "credentials");
        if (credentialName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'credentials'.", id)));
        }
        return (Credential)this.getWithResponse(resourceGroupName, automationAccountName, credentialName, Context.NONE).getValue();
    }

    @Override
    public Response<Credential> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String credentialName = ResourceManagerUtils.getValueFromIdByName(id, "credentials");
        if (credentialName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'credentials'.", id)));
        }
        return this.getWithResponse(resourceGroupName, automationAccountName, credentialName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String credentialName = ResourceManagerUtils.getValueFromIdByName(id, "credentials");
        if (credentialName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'credentials'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, automationAccountName, credentialName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String credentialName = ResourceManagerUtils.getValueFromIdByName(id, "credentials");
        if (credentialName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'credentials'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, automationAccountName, credentialName, context);
    }

    private CredentialsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public CredentialImpl define(String name) {
        return new CredentialImpl(name, this.manager());
    }
}

