/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.DscCompilationJobInner;
import com.azure.resourcemanager.automation.models.DscCompilationJob;
import com.azure.resourcemanager.automation.models.DscCompilationJobCreateParameters;
import com.azure.resourcemanager.automation.models.DscConfigurationAssociationProperty;
import com.azure.resourcemanager.automation.models.JobProvisioningState;
import com.azure.resourcemanager.automation.models.JobStatus;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;

public final class DscCompilationJobImpl
implements DscCompilationJob,
DscCompilationJob.Definition {
    private DscCompilationJobInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private String compilationJobName;
    private DscCompilationJobCreateParameters createParameters;

    DscCompilationJobImpl(DscCompilationJobInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public DscConfigurationAssociationProperty configuration() {
        return this.innerModel().configuration();
    }

    @Override
    public String startedBy() {
        return this.innerModel().startedBy();
    }

    @Override
    public UUID jobId() {
        return this.innerModel().jobId();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public JobProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String runOn() {
        return this.innerModel().runOn();
    }

    @Override
    public JobStatus status() {
        return this.innerModel().status();
    }

    @Override
    public String statusDetails() {
        return this.innerModel().statusDetails();
    }

    @Override
    public OffsetDateTime startTime() {
        return this.innerModel().startTime();
    }

    @Override
    public OffsetDateTime endTime() {
        return this.innerModel().endTime();
    }

    @Override
    public String exception() {
        return this.innerModel().exception();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.innerModel().lastModifiedTime();
    }

    @Override
    public OffsetDateTime lastStatusModifiedTime() {
        return this.innerModel().lastStatusModifiedTime();
    }

    @Override
    public Map<String, String> parameters() {
        Map<String, String> inner = this.innerModel().parameters();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public DscCompilationJobInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DscCompilationJobImpl withExistingAutomationAccount(String resourceGroupName, String automationAccountName) {
        this.resourceGroupName = resourceGroupName;
        this.automationAccountName = automationAccountName;
        return this;
    }

    @Override
    public DscCompilationJob create() {
        this.innerObject = this.serviceManager.serviceClient().getDscCompilationJobs().create(this.resourceGroupName, this.automationAccountName, this.compilationJobName, this.createParameters, Context.NONE);
        return this;
    }

    @Override
    public DscCompilationJob create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDscCompilationJobs().create(this.resourceGroupName, this.automationAccountName, this.compilationJobName, this.createParameters, context);
        return this;
    }

    DscCompilationJobImpl(String name, AutomationManager serviceManager) {
        this.innerObject = new DscCompilationJobInner();
        this.serviceManager = serviceManager;
        this.compilationJobName = name;
        this.createParameters = new DscCompilationJobCreateParameters();
    }

    @Override
    public DscCompilationJob refresh() {
        this.innerObject = (DscCompilationJobInner)((Object)this.serviceManager.serviceClient().getDscCompilationJobs().getWithResponse(this.resourceGroupName, this.automationAccountName, this.compilationJobName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DscCompilationJob refresh(Context context) {
        this.innerObject = (DscCompilationJobInner)((Object)this.serviceManager.serviceClient().getDscCompilationJobs().getWithResponse(this.resourceGroupName, this.automationAccountName, this.compilationJobName, context).getValue());
        return this;
    }

    @Override
    public DscCompilationJobImpl withConfiguration(DscConfigurationAssociationProperty configuration) {
        this.createParameters.withConfiguration(configuration);
        return this;
    }

    @Override
    public DscCompilationJobImpl withRegion(Region location) {
        this.createParameters.withLocation(location.toString());
        return this;
    }

    @Override
    public DscCompilationJobImpl withRegion(String location) {
        this.createParameters.withLocation(location);
        return this;
    }

    @Override
    public DscCompilationJobImpl withTags(Map<String, String> tags) {
        this.createParameters.withTags(tags);
        return this;
    }

    @Override
    public DscCompilationJobImpl withName(String name) {
        this.createParameters.withName(name);
        return this;
    }

    @Override
    public DscCompilationJobImpl withParameters(Map<String, String> parameters) {
        this.createParameters.withParameters(parameters);
        return this;
    }

    @Override
    public DscCompilationJobImpl withIncrementNodeConfigurationBuild(Boolean incrementNodeConfigurationBuild) {
        this.createParameters.withIncrementNodeConfigurationBuild(incrementNodeConfigurationBuild);
        return this;
    }
}

