/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automation.fluent.DscCompilationJobsClient;
import com.azure.resourcemanager.automation.fluent.models.DscCompilationJobInner;
import com.azure.resourcemanager.automation.fluent.models.JobStreamInner;
import com.azure.resourcemanager.automation.implementation.AutomationClientImpl;
import com.azure.resourcemanager.automation.models.DscCompilationJobCreateParameters;
import com.azure.resourcemanager.automation.models.DscCompilationJobListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.UUID;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DscCompilationJobsClientImpl
implements DscCompilationJobsClient {
    private final DscCompilationJobsService service;
    private final AutomationClientImpl client;

    DscCompilationJobsClientImpl(AutomationClientImpl client) {
        this.service = (DscCompilationJobsService)RestProxy.create(DscCompilationJobsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String automationAccountName, String compilationJobName, DscCompilationJobCreateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (compilationJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter compilationJobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, automationAccountName, compilationJobName, this.client.getSubscriptionId(), "2020-01-13-preview", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String automationAccountName, String compilationJobName, DscCompilationJobCreateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (compilationJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter compilationJobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, automationAccountName, compilationJobName, this.client.getSubscriptionId(), "2020-01-13-preview", parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DscCompilationJobInner>, DscCompilationJobInner> beginCreateAsync(String resourceGroupName, String automationAccountName, String compilationJobName, DscCompilationJobCreateParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, automationAccountName, compilationJobName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DscCompilationJobInner.class), (Type)((Object)DscCompilationJobInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DscCompilationJobInner>, DscCompilationJobInner> beginCreateAsync(String resourceGroupName, String automationAccountName, String compilationJobName, DscCompilationJobCreateParameters parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, automationAccountName, compilationJobName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DscCompilationJobInner.class), (Type)((Object)DscCompilationJobInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DscCompilationJobInner>, DscCompilationJobInner> beginCreate(String resourceGroupName, String automationAccountName, String compilationJobName, DscCompilationJobCreateParameters parameters) {
        return this.beginCreateAsync(resourceGroupName, automationAccountName, compilationJobName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DscCompilationJobInner>, DscCompilationJobInner> beginCreate(String resourceGroupName, String automationAccountName, String compilationJobName, DscCompilationJobCreateParameters parameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, automationAccountName, compilationJobName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DscCompilationJobInner> createAsync(String resourceGroupName, String automationAccountName, String compilationJobName, DscCompilationJobCreateParameters parameters) {
        return this.beginCreateAsync(resourceGroupName, automationAccountName, compilationJobName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DscCompilationJobInner> createAsync(String resourceGroupName, String automationAccountName, String compilationJobName, DscCompilationJobCreateParameters parameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, automationAccountName, compilationJobName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DscCompilationJobInner create(String resourceGroupName, String automationAccountName, String compilationJobName, DscCompilationJobCreateParameters parameters) {
        return (DscCompilationJobInner)((Object)this.createAsync(resourceGroupName, automationAccountName, compilationJobName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DscCompilationJobInner create(String resourceGroupName, String automationAccountName, String compilationJobName, DscCompilationJobCreateParameters parameters, Context context) {
        return (DscCompilationJobInner)((Object)this.createAsync(resourceGroupName, automationAccountName, compilationJobName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DscCompilationJobInner>> getWithResponseAsync(String resourceGroupName, String automationAccountName, String compilationJobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (compilationJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter compilationJobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, automationAccountName, compilationJobName, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DscCompilationJobInner>> getWithResponseAsync(String resourceGroupName, String automationAccountName, String compilationJobName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (compilationJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter compilationJobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, automationAccountName, compilationJobName, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DscCompilationJobInner> getAsync(String resourceGroupName, String automationAccountName, String compilationJobName) {
        return this.getWithResponseAsync(resourceGroupName, automationAccountName, compilationJobName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DscCompilationJobInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DscCompilationJobInner> getWithResponse(String resourceGroupName, String automationAccountName, String compilationJobName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, automationAccountName, compilationJobName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DscCompilationJobInner get(String resourceGroupName, String automationAccountName, String compilationJobName) {
        return (DscCompilationJobInner)((Object)this.getWithResponse(resourceGroupName, automationAccountName, compilationJobName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DscCompilationJobInner>> listByAutomationAccountSinglePageAsync(String resourceGroupName, String automationAccountName, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByAutomationAccount(this.client.getEndpoint(), resourceGroupName, automationAccountName, filter, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DscCompilationJobListResult)res.getValue()).value(), ((DscCompilationJobListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DscCompilationJobInner>> listByAutomationAccountSinglePageAsync(String resourceGroupName, String automationAccountName, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByAutomationAccount(this.client.getEndpoint(), resourceGroupName, automationAccountName, filter, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DscCompilationJobListResult)res.getValue()).value(), ((DscCompilationJobListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DscCompilationJobInner> listByAutomationAccountAsync(String resourceGroupName, String automationAccountName, String filter) {
        return new PagedFlux(() -> this.listByAutomationAccountSinglePageAsync(resourceGroupName, automationAccountName, filter), nextLink -> this.listByAutomationAccountNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DscCompilationJobInner> listByAutomationAccountAsync(String resourceGroupName, String automationAccountName) {
        String filter = null;
        return new PagedFlux(() -> this.listByAutomationAccountSinglePageAsync(resourceGroupName, automationAccountName, filter), nextLink -> this.listByAutomationAccountNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DscCompilationJobInner> listByAutomationAccountAsync(String resourceGroupName, String automationAccountName, String filter, Context context) {
        return new PagedFlux(() -> this.listByAutomationAccountSinglePageAsync(resourceGroupName, automationAccountName, filter, context), nextLink -> this.listByAutomationAccountNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DscCompilationJobInner> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        String filter = null;
        return new PagedIterable(this.listByAutomationAccountAsync(resourceGroupName, automationAccountName, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DscCompilationJobInner> listByAutomationAccount(String resourceGroupName, String automationAccountName, String filter, Context context) {
        return new PagedIterable(this.listByAutomationAccountAsync(resourceGroupName, automationAccountName, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JobStreamInner>> getStreamWithResponseAsync(String resourceGroupName, String automationAccountName, UUID jobId, String jobStreamId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (jobId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobId is required and cannot be null."));
        }
        if (jobStreamId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobStreamId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getStream(this.client.getEndpoint(), resourceGroupName, automationAccountName, jobId, jobStreamId, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JobStreamInner>> getStreamWithResponseAsync(String resourceGroupName, String automationAccountName, UUID jobId, String jobStreamId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (jobId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobId is required and cannot be null."));
        }
        if (jobStreamId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobStreamId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getStream(this.client.getEndpoint(), resourceGroupName, automationAccountName, jobId, jobStreamId, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<JobStreamInner> getStreamAsync(String resourceGroupName, String automationAccountName, UUID jobId, String jobStreamId) {
        return this.getStreamWithResponseAsync(resourceGroupName, automationAccountName, jobId, jobStreamId).flatMap(res -> Mono.justOrEmpty((Object)((JobStreamInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<JobStreamInner> getStreamWithResponse(String resourceGroupName, String automationAccountName, UUID jobId, String jobStreamId, Context context) {
        return (Response)this.getStreamWithResponseAsync(resourceGroupName, automationAccountName, jobId, jobStreamId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JobStreamInner getStream(String resourceGroupName, String automationAccountName, UUID jobId, String jobStreamId) {
        return (JobStreamInner)this.getStreamWithResponse(resourceGroupName, automationAccountName, jobId, jobStreamId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DscCompilationJobInner>> listByAutomationAccountNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByAutomationAccountNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DscCompilationJobListResult)res.getValue()).value(), ((DscCompilationJobListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DscCompilationJobInner>> listByAutomationAccountNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByAutomationAccountNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DscCompilationJobListResult)res.getValue()).value(), ((DscCompilationJobListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomationClientDscC")
    public static interface DscCompilationJobsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/compilationjobs/{compilationJobName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @PathParam(value="compilationJobName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") DscCompilationJobCreateParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/compilationjobs/{compilationJobName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DscCompilationJobInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @PathParam(value="compilationJobName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/compilationjobs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DscCompilationJobListResult>> listByAutomationAccount(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @QueryParam(value="$filter") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/compilationjobs/{jobId}/streams/{jobStreamId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobStreamInner>> getStream(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @PathParam(value="jobId") UUID var4, @PathParam(value="jobStreamId") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DscCompilationJobListResult>> listByAutomationAccountNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

