/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.DscCompilationJobsClient;
import com.azure.resourcemanager.automation.fluent.models.DscCompilationJobInner;
import com.azure.resourcemanager.automation.fluent.models.JobStreamInner;
import com.azure.resourcemanager.automation.implementation.DscCompilationJobImpl;
import com.azure.resourcemanager.automation.implementation.JobStreamImpl;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.DscCompilationJob;
import com.azure.resourcemanager.automation.models.DscCompilationJobs;
import com.azure.resourcemanager.automation.models.JobStream;
import java.util.UUID;

public final class DscCompilationJobsImpl
implements DscCompilationJobs {
    private static final ClientLogger LOGGER = new ClientLogger(DscCompilationJobsImpl.class);
    private final DscCompilationJobsClient innerClient;
    private final AutomationManager serviceManager;

    public DscCompilationJobsImpl(DscCompilationJobsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DscCompilationJob> getWithResponse(String resourceGroupName, String automationAccountName, String compilationJobName, Context context) {
        Response<DscCompilationJobInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, compilationJobName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DscCompilationJobImpl((DscCompilationJobInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DscCompilationJob get(String resourceGroupName, String automationAccountName, String compilationJobName) {
        DscCompilationJobInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, compilationJobName);
        if (inner != null) {
            return new DscCompilationJobImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<DscCompilationJob> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        PagedIterable<DscCompilationJobInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DscCompilationJobImpl((DscCompilationJobInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DscCompilationJob> listByAutomationAccount(String resourceGroupName, String automationAccountName, String filter, Context context) {
        PagedIterable<DscCompilationJobInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DscCompilationJobImpl((DscCompilationJobInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<JobStream> getStreamWithResponse(String resourceGroupName, String automationAccountName, UUID jobId, String jobStreamId, Context context) {
        Response<JobStreamInner> inner = this.serviceClient().getStreamWithResponse(resourceGroupName, automationAccountName, jobId, jobStreamId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new JobStreamImpl((JobStreamInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public JobStream getStream(String resourceGroupName, String automationAccountName, UUID jobId, String jobStreamId) {
        JobStreamInner inner = this.serviceClient().getStream(resourceGroupName, automationAccountName, jobId, jobStreamId);
        if (inner != null) {
            return new JobStreamImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DscCompilationJob getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String compilationJobName = ResourceManagerUtils.getValueFromIdByName(id, "compilationjobs");
        if (compilationJobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'compilationjobs'.", id)));
        }
        return (DscCompilationJob)this.getWithResponse(resourceGroupName, automationAccountName, compilationJobName, Context.NONE).getValue();
    }

    @Override
    public Response<DscCompilationJob> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String compilationJobName = ResourceManagerUtils.getValueFromIdByName(id, "compilationjobs");
        if (compilationJobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'compilationjobs'.", id)));
        }
        return this.getWithResponse(resourceGroupName, automationAccountName, compilationJobName, context);
    }

    private DscCompilationJobsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DscCompilationJobImpl define(String name) {
        return new DscCompilationJobImpl(name, this.manager());
    }
}

