/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.DscConfigurationInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.ContentSource;
import com.azure.resourcemanager.automation.models.DscConfiguration;
import com.azure.resourcemanager.automation.models.DscConfigurationCreateOrUpdateParameters;
import com.azure.resourcemanager.automation.models.DscConfigurationParameter;
import com.azure.resourcemanager.automation.models.DscConfigurationProvisioningState;
import com.azure.resourcemanager.automation.models.DscConfigurationState;
import com.azure.resourcemanager.automation.models.DscConfigurationUpdateParameters;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;

public final class DscConfigurationImpl
implements DscConfiguration,
DscConfiguration.Definition,
DscConfiguration.Update {
    private DscConfigurationInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private String configurationName;
    private DscConfigurationCreateOrUpdateParameters createParameters;
    private DscConfigurationUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public DscConfigurationProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Integer jobCount() {
        return this.innerModel().jobCount();
    }

    @Override
    public Map<String, DscConfigurationParameter> parameters() {
        Map<String, DscConfigurationParameter> inner = this.innerModel().parameters();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ContentSource source() {
        return this.innerModel().source();
    }

    @Override
    public DscConfigurationState state() {
        return this.innerModel().state();
    }

    @Override
    public Boolean logVerbose() {
        return this.innerModel().logVerbose();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.innerModel().lastModifiedTime();
    }

    @Override
    public Integer nodeConfigurationCount() {
        return this.innerModel().nodeConfigurationCount();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DscConfigurationInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DscConfigurationImpl withExistingAutomationAccount(String resourceGroupName, String automationAccountName) {
        this.resourceGroupName = resourceGroupName;
        this.automationAccountName = automationAccountName;
        return this;
    }

    @Override
    public DscConfiguration create() {
        this.innerObject = (DscConfigurationInner)((Object)this.serviceManager.serviceClient().getDscConfigurations().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.configurationName, this.createParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public DscConfiguration create(Context context) {
        this.innerObject = (DscConfigurationInner)((Object)this.serviceManager.serviceClient().getDscConfigurations().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.configurationName, this.createParameters, context).getValue());
        return this;
    }

    DscConfigurationImpl(String name, AutomationManager serviceManager) {
        this.innerObject = new DscConfigurationInner();
        this.serviceManager = serviceManager;
        this.configurationName = name;
        this.createParameters = new DscConfigurationCreateOrUpdateParameters();
    }

    @Override
    public DscConfigurationImpl update() {
        this.updateParameters = new DscConfigurationUpdateParameters();
        return this;
    }

    @Override
    public DscConfiguration apply() {
        this.innerObject = (DscConfigurationInner)((Object)this.serviceManager.serviceClient().getDscConfigurations().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.configurationName, this.updateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public DscConfiguration apply(Context context) {
        this.innerObject = (DscConfigurationInner)((Object)this.serviceManager.serviceClient().getDscConfigurations().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.configurationName, this.updateParameters, context).getValue());
        return this;
    }

    DscConfigurationImpl(DscConfigurationInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.automationAccountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "automationAccounts");
        this.configurationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "configurations");
    }

    @Override
    public DscConfiguration refresh() {
        this.innerObject = (DscConfigurationInner)((Object)this.serviceManager.serviceClient().getDscConfigurations().getWithResponse(this.resourceGroupName, this.automationAccountName, this.configurationName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DscConfiguration refresh(Context context) {
        this.innerObject = (DscConfigurationInner)((Object)this.serviceManager.serviceClient().getDscConfigurations().getWithResponse(this.resourceGroupName, this.automationAccountName, this.configurationName, context).getValue());
        return this;
    }

    @Override
    public DscConfigurationImpl withSource(ContentSource source) {
        if (this.isInCreateMode()) {
            this.createParameters.withSource(source);
            return this;
        }
        this.updateParameters.withSource(source);
        return this;
    }

    @Override
    public DscConfigurationImpl withRegion(Region location) {
        this.createParameters.withLocation(location.toString());
        return this;
    }

    @Override
    public DscConfigurationImpl withRegion(String location) {
        this.createParameters.withLocation(location);
        return this;
    }

    @Override
    public DscConfigurationImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.createParameters.withTags(tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public DscConfigurationImpl withName(String name) {
        if (this.isInCreateMode()) {
            this.createParameters.withName(name);
            return this;
        }
        this.updateParameters.withName(name);
        return this;
    }

    @Override
    public DscConfigurationImpl withLogVerbose(Boolean logVerbose) {
        if (this.isInCreateMode()) {
            this.createParameters.withLogVerbose(logVerbose);
            return this;
        }
        this.updateParameters.withLogVerbose(logVerbose);
        return this;
    }

    @Override
    public DscConfigurationImpl withLogProgress(Boolean logProgress) {
        if (this.isInCreateMode()) {
            this.createParameters.withLogProgress(logProgress);
            return this;
        }
        this.updateParameters.withLogProgress(logProgress);
        return this;
    }

    @Override
    public DscConfigurationImpl withParameters(Map<String, DscConfigurationParameter> parameters) {
        if (this.isInCreateMode()) {
            this.createParameters.withParameters(parameters);
            return this;
        }
        this.updateParameters.withParameters(parameters);
        return this;
    }

    @Override
    public DscConfigurationImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.createParameters.withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

