/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.DscConfigurationsClient;
import com.azure.resourcemanager.automation.fluent.models.DscConfigurationInner;
import com.azure.resourcemanager.automation.implementation.DscConfigurationImpl;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.DscConfiguration;
import com.azure.resourcemanager.automation.models.DscConfigurations;

public final class DscConfigurationsImpl
implements DscConfigurations {
    private static final ClientLogger LOGGER = new ClientLogger(DscConfigurationsImpl.class);
    private final DscConfigurationsClient innerClient;
    private final AutomationManager serviceManager;

    public DscConfigurationsImpl(DscConfigurationsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String automationAccountName, String configurationName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, automationAccountName, configurationName, context);
    }

    @Override
    public void delete(String resourceGroupName, String automationAccountName, String configurationName) {
        this.serviceClient().delete(resourceGroupName, automationAccountName, configurationName);
    }

    @Override
    public Response<DscConfiguration> getWithResponse(String resourceGroupName, String automationAccountName, String configurationName, Context context) {
        Response<DscConfigurationInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, configurationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DscConfigurationImpl((DscConfigurationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DscConfiguration get(String resourceGroupName, String automationAccountName, String configurationName) {
        DscConfigurationInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, configurationName);
        if (inner != null) {
            return new DscConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DscConfiguration> createOrUpdateWithResponse(String resourceGroupName, String automationAccountName, String configurationName, String parameters, Context context) {
        Response<DscConfigurationInner> inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, automationAccountName, configurationName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DscConfigurationImpl((DscConfigurationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DscConfiguration createOrUpdate(String resourceGroupName, String automationAccountName, String configurationName, String parameters) {
        DscConfigurationInner inner = this.serviceClient().createOrUpdate(resourceGroupName, automationAccountName, configurationName, parameters);
        if (inner != null) {
            return new DscConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DscConfiguration> updateWithResponse(String resourceGroupName, String automationAccountName, String configurationName, String parameters, Context context) {
        Response<DscConfigurationInner> inner = this.serviceClient().updateWithResponse(resourceGroupName, automationAccountName, configurationName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DscConfigurationImpl((DscConfigurationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Response<String> getContentWithResponse(String resourceGroupName, String automationAccountName, String configurationName, Context context) {
        return this.serviceClient().getContentWithResponse(resourceGroupName, automationAccountName, configurationName, context);
    }

    @Override
    public String getContent(String resourceGroupName, String automationAccountName, String configurationName) {
        return this.serviceClient().getContent(resourceGroupName, automationAccountName, configurationName);
    }

    @Override
    public PagedIterable<DscConfiguration> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        PagedIterable<DscConfigurationInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DscConfigurationImpl((DscConfigurationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DscConfiguration> listByAutomationAccount(String resourceGroupName, String automationAccountName, String filter, Integer skip, Integer top, String inlinecount, Context context) {
        PagedIterable<DscConfigurationInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, filter, skip, top, inlinecount, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DscConfigurationImpl((DscConfigurationInner)((Object)inner1), this.manager()));
    }

    @Override
    public DscConfiguration getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String configurationName = ResourceManagerUtils.getValueFromIdByName(id, "configurations");
        if (configurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurations'.", id)));
        }
        return (DscConfiguration)this.getWithResponse(resourceGroupName, automationAccountName, configurationName, Context.NONE).getValue();
    }

    @Override
    public Response<DscConfiguration> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String configurationName = ResourceManagerUtils.getValueFromIdByName(id, "configurations");
        if (configurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, automationAccountName, configurationName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String configurationName = ResourceManagerUtils.getValueFromIdByName(id, "configurations");
        if (configurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurations'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, automationAccountName, configurationName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String configurationName = ResourceManagerUtils.getValueFromIdByName(id, "configurations");
        if (configurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurations'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, automationAccountName, configurationName, context);
    }

    private DscConfigurationsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DscConfigurationImpl define(String name) {
        return new DscConfigurationImpl(name, this.manager());
    }
}

