/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.DscNodeConfigurationInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.ContentSource;
import com.azure.resourcemanager.automation.models.DscConfigurationAssociationProperty;
import com.azure.resourcemanager.automation.models.DscNodeConfiguration;
import com.azure.resourcemanager.automation.models.DscNodeConfigurationCreateOrUpdateParameters;
import java.time.OffsetDateTime;
import java.util.Map;

public final class DscNodeConfigurationImpl
implements DscNodeConfiguration,
DscNodeConfiguration.Definition,
DscNodeConfiguration.Update {
    private DscNodeConfigurationInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private String nodeConfigurationName;
    private DscNodeConfigurationCreateOrUpdateParameters createParameters;
    private DscNodeConfigurationCreateOrUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.innerModel().lastModifiedTime();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public DscConfigurationAssociationProperty configuration() {
        return this.innerModel().configuration();
    }

    @Override
    public String source() {
        return this.innerModel().source();
    }

    @Override
    public Long nodeCount() {
        return this.innerModel().nodeCount();
    }

    @Override
    public Boolean incrementNodeConfigurationBuild() {
        return this.innerModel().incrementNodeConfigurationBuild();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DscNodeConfigurationInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DscNodeConfigurationImpl withExistingAutomationAccount(String resourceGroupName, String automationAccountName) {
        this.resourceGroupName = resourceGroupName;
        this.automationAccountName = automationAccountName;
        return this;
    }

    @Override
    public DscNodeConfiguration create() {
        this.innerObject = this.serviceManager.serviceClient().getDscNodeConfigurations().createOrUpdate(this.resourceGroupName, this.automationAccountName, this.nodeConfigurationName, this.createParameters, Context.NONE);
        return this;
    }

    @Override
    public DscNodeConfiguration create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDscNodeConfigurations().createOrUpdate(this.resourceGroupName, this.automationAccountName, this.nodeConfigurationName, this.createParameters, context);
        return this;
    }

    DscNodeConfigurationImpl(String name, AutomationManager serviceManager) {
        this.innerObject = new DscNodeConfigurationInner();
        this.serviceManager = serviceManager;
        this.nodeConfigurationName = name;
        this.createParameters = new DscNodeConfigurationCreateOrUpdateParameters();
    }

    @Override
    public DscNodeConfigurationImpl update() {
        this.updateParameters = new DscNodeConfigurationCreateOrUpdateParameters();
        return this;
    }

    @Override
    public DscNodeConfiguration apply() {
        this.innerObject = this.serviceManager.serviceClient().getDscNodeConfigurations().createOrUpdate(this.resourceGroupName, this.automationAccountName, this.nodeConfigurationName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public DscNodeConfiguration apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDscNodeConfigurations().createOrUpdate(this.resourceGroupName, this.automationAccountName, this.nodeConfigurationName, this.updateParameters, context);
        return this;
    }

    DscNodeConfigurationImpl(DscNodeConfigurationInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.automationAccountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "automationAccounts");
        this.nodeConfigurationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "nodeConfigurations");
    }

    @Override
    public DscNodeConfiguration refresh() {
        this.innerObject = (DscNodeConfigurationInner)((Object)this.serviceManager.serviceClient().getDscNodeConfigurations().getWithResponse(this.resourceGroupName, this.automationAccountName, this.nodeConfigurationName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DscNodeConfiguration refresh(Context context) {
        this.innerObject = (DscNodeConfigurationInner)((Object)this.serviceManager.serviceClient().getDscNodeConfigurations().getWithResponse(this.resourceGroupName, this.automationAccountName, this.nodeConfigurationName, context).getValue());
        return this;
    }

    @Override
    public DscNodeConfigurationImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.createParameters.withTags(tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public DscNodeConfigurationImpl withName(String name) {
        if (this.isInCreateMode()) {
            this.createParameters.withName(name);
            return this;
        }
        this.updateParameters.withName(name);
        return this;
    }

    @Override
    public DscNodeConfigurationImpl withSource(ContentSource source) {
        if (this.isInCreateMode()) {
            this.createParameters.withSource(source);
            return this;
        }
        this.updateParameters.withSource(source);
        return this;
    }

    @Override
    public DscNodeConfigurationImpl withConfiguration(DscConfigurationAssociationProperty configuration) {
        if (this.isInCreateMode()) {
            this.createParameters.withConfiguration(configuration);
            return this;
        }
        this.updateParameters.withConfiguration(configuration);
        return this;
    }

    @Override
    public DscNodeConfigurationImpl withIncrementNodeConfigurationBuild(Boolean incrementNodeConfigurationBuild) {
        if (this.isInCreateMode()) {
            this.createParameters.withIncrementNodeConfigurationBuild(incrementNodeConfigurationBuild);
            return this;
        }
        this.updateParameters.withIncrementNodeConfigurationBuild(incrementNodeConfigurationBuild);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

