/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.DscNodeConfigurationsClient;
import com.azure.resourcemanager.automation.fluent.models.DscNodeConfigurationInner;
import com.azure.resourcemanager.automation.implementation.DscNodeConfigurationImpl;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.DscNodeConfiguration;
import com.azure.resourcemanager.automation.models.DscNodeConfigurations;

public final class DscNodeConfigurationsImpl
implements DscNodeConfigurations {
    private static final ClientLogger LOGGER = new ClientLogger(DscNodeConfigurationsImpl.class);
    private final DscNodeConfigurationsClient innerClient;
    private final AutomationManager serviceManager;

    public DscNodeConfigurationsImpl(DscNodeConfigurationsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String automationAccountName, String nodeConfigurationName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, automationAccountName, nodeConfigurationName, context);
    }

    @Override
    public void delete(String resourceGroupName, String automationAccountName, String nodeConfigurationName) {
        this.serviceClient().delete(resourceGroupName, automationAccountName, nodeConfigurationName);
    }

    @Override
    public Response<DscNodeConfiguration> getWithResponse(String resourceGroupName, String automationAccountName, String nodeConfigurationName, Context context) {
        Response<DscNodeConfigurationInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, nodeConfigurationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DscNodeConfigurationImpl((DscNodeConfigurationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DscNodeConfiguration get(String resourceGroupName, String automationAccountName, String nodeConfigurationName) {
        DscNodeConfigurationInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, nodeConfigurationName);
        if (inner != null) {
            return new DscNodeConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<DscNodeConfiguration> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        PagedIterable<DscNodeConfigurationInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DscNodeConfigurationImpl((DscNodeConfigurationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DscNodeConfiguration> listByAutomationAccount(String resourceGroupName, String automationAccountName, String filter, Integer skip, Integer top, String inlinecount, Context context) {
        PagedIterable<DscNodeConfigurationInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, filter, skip, top, inlinecount, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DscNodeConfigurationImpl((DscNodeConfigurationInner)((Object)inner1), this.manager()));
    }

    @Override
    public DscNodeConfiguration getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String nodeConfigurationName = ResourceManagerUtils.getValueFromIdByName(id, "nodeConfigurations");
        if (nodeConfigurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'nodeConfigurations'.", id)));
        }
        return (DscNodeConfiguration)this.getWithResponse(resourceGroupName, automationAccountName, nodeConfigurationName, Context.NONE).getValue();
    }

    @Override
    public Response<DscNodeConfiguration> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String nodeConfigurationName = ResourceManagerUtils.getValueFromIdByName(id, "nodeConfigurations");
        if (nodeConfigurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'nodeConfigurations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, automationAccountName, nodeConfigurationName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String nodeConfigurationName = ResourceManagerUtils.getValueFromIdByName(id, "nodeConfigurations");
        if (nodeConfigurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'nodeConfigurations'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, automationAccountName, nodeConfigurationName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String nodeConfigurationName = ResourceManagerUtils.getValueFromIdByName(id, "nodeConfigurations");
        if (nodeConfigurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'nodeConfigurations'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, automationAccountName, nodeConfigurationName, context);
    }

    private DscNodeConfigurationsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DscNodeConfigurationImpl define(String name) {
        return new DscNodeConfigurationImpl(name, this.manager());
    }
}

