/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.DscNodesClient;
import com.azure.resourcemanager.automation.fluent.models.DscNodeInner;
import com.azure.resourcemanager.automation.implementation.DscNodeImpl;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.DscNode;
import com.azure.resourcemanager.automation.models.DscNodeUpdateParameters;
import com.azure.resourcemanager.automation.models.DscNodes;

public final class DscNodesImpl
implements DscNodes {
    private static final ClientLogger LOGGER = new ClientLogger(DscNodesImpl.class);
    private final DscNodesClient innerClient;
    private final AutomationManager serviceManager;

    public DscNodesImpl(DscNodesClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String automationAccountName, String nodeId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, automationAccountName, nodeId, context);
    }

    @Override
    public void delete(String resourceGroupName, String automationAccountName, String nodeId) {
        this.serviceClient().delete(resourceGroupName, automationAccountName, nodeId);
    }

    @Override
    public Response<DscNode> getWithResponse(String resourceGroupName, String automationAccountName, String nodeId, Context context) {
        Response<DscNodeInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, nodeId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DscNodeImpl((DscNodeInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DscNode get(String resourceGroupName, String automationAccountName, String nodeId) {
        DscNodeInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, nodeId);
        if (inner != null) {
            return new DscNodeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DscNode> updateWithResponse(String resourceGroupName, String automationAccountName, String nodeId, DscNodeUpdateParameters dscNodeUpdateParameters, Context context) {
        Response<DscNodeInner> inner = this.serviceClient().updateWithResponse(resourceGroupName, automationAccountName, nodeId, dscNodeUpdateParameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DscNodeImpl((DscNodeInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DscNode update(String resourceGroupName, String automationAccountName, String nodeId, DscNodeUpdateParameters dscNodeUpdateParameters) {
        DscNodeInner inner = this.serviceClient().update(resourceGroupName, automationAccountName, nodeId, dscNodeUpdateParameters);
        if (inner != null) {
            return new DscNodeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<DscNode> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        PagedIterable<DscNodeInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DscNodeImpl((DscNodeInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DscNode> listByAutomationAccount(String resourceGroupName, String automationAccountName, String filter, Integer skip, Integer top, String inlinecount, Context context) {
        PagedIterable<DscNodeInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, filter, skip, top, inlinecount, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DscNodeImpl((DscNodeInner)((Object)inner1), this.manager()));
    }

    private DscNodesClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }
}

