/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automation.fluent.FieldsClient;
import com.azure.resourcemanager.automation.fluent.models.TypeFieldInner;
import com.azure.resourcemanager.automation.implementation.AutomationClientImpl;
import com.azure.resourcemanager.automation.models.TypeFieldListResult;
import reactor.core.publisher.Mono;

public final class FieldsClientImpl
implements FieldsClient {
    private final FieldsService service;
    private final AutomationClientImpl client;

    FieldsClientImpl(AutomationClientImpl client) {
        this.service = (FieldsService)RestProxy.create(FieldsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TypeFieldInner>> listByTypeSinglePageAsync(String resourceGroupName, String automationAccountName, String moduleName, String typeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (moduleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter moduleName is required and cannot be null."));
        }
        if (typeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter typeName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByType(this.client.getEndpoint(), resourceGroupName, automationAccountName, moduleName, typeName, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TypeFieldListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TypeFieldInner>> listByTypeSinglePageAsync(String resourceGroupName, String automationAccountName, String moduleName, String typeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (moduleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter moduleName is required and cannot be null."));
        }
        if (typeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter typeName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByType(this.client.getEndpoint(), resourceGroupName, automationAccountName, moduleName, typeName, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TypeFieldListResult)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TypeFieldInner> listByTypeAsync(String resourceGroupName, String automationAccountName, String moduleName, String typeName) {
        return new PagedFlux(() -> this.listByTypeSinglePageAsync(resourceGroupName, automationAccountName, moduleName, typeName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TypeFieldInner> listByTypeAsync(String resourceGroupName, String automationAccountName, String moduleName, String typeName, Context context) {
        return new PagedFlux(() -> this.listByTypeSinglePageAsync(resourceGroupName, automationAccountName, moduleName, typeName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TypeFieldInner> listByType(String resourceGroupName, String automationAccountName, String moduleName, String typeName) {
        return new PagedIterable(this.listByTypeAsync(resourceGroupName, automationAccountName, moduleName, typeName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TypeFieldInner> listByType(String resourceGroupName, String automationAccountName, String moduleName, String typeName, Context context) {
        return new PagedIterable(this.listByTypeAsync(resourceGroupName, automationAccountName, moduleName, typeName, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomationClientFiel")
    public static interface FieldsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/modules/{moduleName}/types/{typeName}/fields")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TypeFieldListResult>> listByType(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @PathParam(value="moduleName") String var4, @PathParam(value="typeName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

