/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.FieldsClient;
import com.azure.resourcemanager.automation.fluent.models.TypeFieldInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.implementation.TypeFieldImpl;
import com.azure.resourcemanager.automation.models.Fields;
import com.azure.resourcemanager.automation.models.TypeField;

public final class FieldsImpl
implements Fields {
    private static final ClientLogger LOGGER = new ClientLogger(FieldsImpl.class);
    private final FieldsClient innerClient;
    private final AutomationManager serviceManager;

    public FieldsImpl(FieldsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<TypeField> listByType(String resourceGroupName, String automationAccountName, String moduleName, String typeName) {
        PagedIterable<TypeFieldInner> inner = this.serviceClient().listByType(resourceGroupName, automationAccountName, moduleName, typeName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TypeFieldImpl((TypeFieldInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<TypeField> listByType(String resourceGroupName, String automationAccountName, String moduleName, String typeName, Context context) {
        PagedIterable<TypeFieldInner> inner = this.serviceClient().listByType(resourceGroupName, automationAccountName, moduleName, typeName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TypeFieldImpl((TypeFieldInner)inner1, this.manager()));
    }

    private FieldsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }
}

