/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.HybridRunbookWorkerGroupInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.GroupTypeEnum;
import com.azure.resourcemanager.automation.models.HybridRunbookWorkerGroup;
import com.azure.resourcemanager.automation.models.HybridRunbookWorkerGroupCreateOrUpdateParameters;
import com.azure.resourcemanager.automation.models.RunAsCredentialAssociationProperty;

public final class HybridRunbookWorkerGroupImpl
implements HybridRunbookWorkerGroup,
HybridRunbookWorkerGroup.Definition,
HybridRunbookWorkerGroup.Update {
    private HybridRunbookWorkerGroupInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private String hybridRunbookWorkerGroupName;
    private HybridRunbookWorkerGroupCreateOrUpdateParameters createHybridRunbookWorkerGroupCreationParameters;
    private HybridRunbookWorkerGroupCreateOrUpdateParameters updateHybridRunbookWorkerGroupUpdationParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public GroupTypeEnum groupType() {
        return this.innerModel().groupType();
    }

    @Override
    public RunAsCredentialAssociationProperty credential() {
        return this.innerModel().credential();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public HybridRunbookWorkerGroupInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public HybridRunbookWorkerGroupImpl withExistingAutomationAccount(String resourceGroupName, String automationAccountName) {
        this.resourceGroupName = resourceGroupName;
        this.automationAccountName = automationAccountName;
        return this;
    }

    @Override
    public HybridRunbookWorkerGroup create() {
        this.innerObject = (HybridRunbookWorkerGroupInner)((Object)this.serviceManager.serviceClient().getHybridRunbookWorkerGroups().createWithResponse(this.resourceGroupName, this.automationAccountName, this.hybridRunbookWorkerGroupName, this.createHybridRunbookWorkerGroupCreationParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public HybridRunbookWorkerGroup create(Context context) {
        this.innerObject = (HybridRunbookWorkerGroupInner)((Object)this.serviceManager.serviceClient().getHybridRunbookWorkerGroups().createWithResponse(this.resourceGroupName, this.automationAccountName, this.hybridRunbookWorkerGroupName, this.createHybridRunbookWorkerGroupCreationParameters, context).getValue());
        return this;
    }

    HybridRunbookWorkerGroupImpl(String name, AutomationManager serviceManager) {
        this.innerObject = new HybridRunbookWorkerGroupInner();
        this.serviceManager = serviceManager;
        this.hybridRunbookWorkerGroupName = name;
        this.createHybridRunbookWorkerGroupCreationParameters = new HybridRunbookWorkerGroupCreateOrUpdateParameters();
    }

    @Override
    public HybridRunbookWorkerGroupImpl update() {
        this.updateHybridRunbookWorkerGroupUpdationParameters = new HybridRunbookWorkerGroupCreateOrUpdateParameters();
        return this;
    }

    @Override
    public HybridRunbookWorkerGroup apply() {
        this.innerObject = (HybridRunbookWorkerGroupInner)((Object)this.serviceManager.serviceClient().getHybridRunbookWorkerGroups().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.hybridRunbookWorkerGroupName, this.updateHybridRunbookWorkerGroupUpdationParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public HybridRunbookWorkerGroup apply(Context context) {
        this.innerObject = (HybridRunbookWorkerGroupInner)((Object)this.serviceManager.serviceClient().getHybridRunbookWorkerGroups().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.hybridRunbookWorkerGroupName, this.updateHybridRunbookWorkerGroupUpdationParameters, context).getValue());
        return this;
    }

    HybridRunbookWorkerGroupImpl(HybridRunbookWorkerGroupInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.automationAccountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "automationAccounts");
        this.hybridRunbookWorkerGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "hybridRunbookWorkerGroups");
    }

    @Override
    public HybridRunbookWorkerGroup refresh() {
        this.innerObject = (HybridRunbookWorkerGroupInner)((Object)this.serviceManager.serviceClient().getHybridRunbookWorkerGroups().getWithResponse(this.resourceGroupName, this.automationAccountName, this.hybridRunbookWorkerGroupName, Context.NONE).getValue());
        return this;
    }

    @Override
    public HybridRunbookWorkerGroup refresh(Context context) {
        this.innerObject = (HybridRunbookWorkerGroupInner)((Object)this.serviceManager.serviceClient().getHybridRunbookWorkerGroups().getWithResponse(this.resourceGroupName, this.automationAccountName, this.hybridRunbookWorkerGroupName, context).getValue());
        return this;
    }

    @Override
    public HybridRunbookWorkerGroupImpl withName(String name) {
        if (this.isInCreateMode()) {
            this.createHybridRunbookWorkerGroupCreationParameters.withName(name);
            return this;
        }
        this.updateHybridRunbookWorkerGroupUpdationParameters.withName(name);
        return this;
    }

    @Override
    public HybridRunbookWorkerGroupImpl withCredential(RunAsCredentialAssociationProperty credential) {
        if (this.isInCreateMode()) {
            this.createHybridRunbookWorkerGroupCreationParameters.withCredential(credential);
            return this;
        }
        this.updateHybridRunbookWorkerGroupUpdationParameters.withCredential(credential);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

