/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.HybridRunbookWorkerGroupsClient;
import com.azure.resourcemanager.automation.fluent.models.HybridRunbookWorkerGroupInner;
import com.azure.resourcemanager.automation.implementation.HybridRunbookWorkerGroupImpl;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.HybridRunbookWorkerGroup;
import com.azure.resourcemanager.automation.models.HybridRunbookWorkerGroups;

public final class HybridRunbookWorkerGroupsImpl
implements HybridRunbookWorkerGroups {
    private static final ClientLogger LOGGER = new ClientLogger(HybridRunbookWorkerGroupsImpl.class);
    private final HybridRunbookWorkerGroupsClient innerClient;
    private final AutomationManager serviceManager;

    public HybridRunbookWorkerGroupsImpl(HybridRunbookWorkerGroupsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, context);
    }

    @Override
    public void delete(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName) {
        this.serviceClient().delete(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName);
    }

    @Override
    public Response<HybridRunbookWorkerGroup> getWithResponse(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, Context context) {
        Response<HybridRunbookWorkerGroupInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new HybridRunbookWorkerGroupImpl((HybridRunbookWorkerGroupInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public HybridRunbookWorkerGroup get(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName) {
        HybridRunbookWorkerGroupInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName);
        if (inner != null) {
            return new HybridRunbookWorkerGroupImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<HybridRunbookWorkerGroup> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        PagedIterable<HybridRunbookWorkerGroupInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new HybridRunbookWorkerGroupImpl((HybridRunbookWorkerGroupInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<HybridRunbookWorkerGroup> listByAutomationAccount(String resourceGroupName, String automationAccountName, String filter, Context context) {
        PagedIterable<HybridRunbookWorkerGroupInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new HybridRunbookWorkerGroupImpl((HybridRunbookWorkerGroupInner)((Object)inner1), this.manager()));
    }

    @Override
    public HybridRunbookWorkerGroup getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String hybridRunbookWorkerGroupName = ResourceManagerUtils.getValueFromIdByName(id, "hybridRunbookWorkerGroups");
        if (hybridRunbookWorkerGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'hybridRunbookWorkerGroups'.", id)));
        }
        return (HybridRunbookWorkerGroup)this.getWithResponse(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, Context.NONE).getValue();
    }

    @Override
    public Response<HybridRunbookWorkerGroup> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String hybridRunbookWorkerGroupName = ResourceManagerUtils.getValueFromIdByName(id, "hybridRunbookWorkerGroups");
        if (hybridRunbookWorkerGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'hybridRunbookWorkerGroups'.", id)));
        }
        return this.getWithResponse(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String hybridRunbookWorkerGroupName = ResourceManagerUtils.getValueFromIdByName(id, "hybridRunbookWorkerGroups");
        if (hybridRunbookWorkerGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'hybridRunbookWorkerGroups'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String hybridRunbookWorkerGroupName = ResourceManagerUtils.getValueFromIdByName(id, "hybridRunbookWorkerGroups");
        if (hybridRunbookWorkerGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'hybridRunbookWorkerGroups'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, context);
    }

    private HybridRunbookWorkerGroupsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public HybridRunbookWorkerGroupImpl define(String name) {
        return new HybridRunbookWorkerGroupImpl(name, this.manager());
    }
}

