/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.HybridRunbookWorkerInner;
import com.azure.resourcemanager.automation.models.HybridRunbookWorker;
import com.azure.resourcemanager.automation.models.HybridRunbookWorkerCreateParameters;
import com.azure.resourcemanager.automation.models.HybridRunbookWorkerMoveParameters;
import com.azure.resourcemanager.automation.models.WorkerType;
import java.time.OffsetDateTime;

public final class HybridRunbookWorkerImpl
implements HybridRunbookWorker,
HybridRunbookWorker.Definition {
    private HybridRunbookWorkerInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private String hybridRunbookWorkerGroupName;
    private String hybridRunbookWorkerId;
    private HybridRunbookWorkerCreateParameters createHybridRunbookWorkerCreationParameters;

    HybridRunbookWorkerImpl(HybridRunbookWorkerInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String ip() {
        return this.innerModel().ip();
    }

    @Override
    public OffsetDateTime registeredDateTime() {
        return this.innerModel().registeredDateTime();
    }

    @Override
    public OffsetDateTime lastSeenDateTime() {
        return this.innerModel().lastSeenDateTime();
    }

    @Override
    public String vmResourceId() {
        return this.innerModel().vmResourceId();
    }

    @Override
    public WorkerType workerType() {
        return this.innerModel().workerType();
    }

    @Override
    public String workerName() {
        return this.innerModel().workerName();
    }

    @Override
    public HybridRunbookWorkerInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public HybridRunbookWorkerImpl withExistingHybridRunbookWorkerGroup(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName) {
        this.resourceGroupName = resourceGroupName;
        this.automationAccountName = automationAccountName;
        this.hybridRunbookWorkerGroupName = hybridRunbookWorkerGroupName;
        return this;
    }

    @Override
    public HybridRunbookWorker create() {
        this.innerObject = (HybridRunbookWorkerInner)((Object)this.serviceManager.serviceClient().getHybridRunbookWorkers().createWithResponse(this.resourceGroupName, this.automationAccountName, this.hybridRunbookWorkerGroupName, this.hybridRunbookWorkerId, this.createHybridRunbookWorkerCreationParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public HybridRunbookWorker create(Context context) {
        this.innerObject = (HybridRunbookWorkerInner)((Object)this.serviceManager.serviceClient().getHybridRunbookWorkers().createWithResponse(this.resourceGroupName, this.automationAccountName, this.hybridRunbookWorkerGroupName, this.hybridRunbookWorkerId, this.createHybridRunbookWorkerCreationParameters, context).getValue());
        return this;
    }

    HybridRunbookWorkerImpl(String name, AutomationManager serviceManager) {
        this.innerObject = new HybridRunbookWorkerInner();
        this.serviceManager = serviceManager;
        this.hybridRunbookWorkerId = name;
        this.createHybridRunbookWorkerCreationParameters = new HybridRunbookWorkerCreateParameters();
    }

    @Override
    public HybridRunbookWorker refresh() {
        this.innerObject = (HybridRunbookWorkerInner)((Object)this.serviceManager.serviceClient().getHybridRunbookWorkers().getWithResponse(this.resourceGroupName, this.automationAccountName, this.hybridRunbookWorkerGroupName, this.hybridRunbookWorkerId, Context.NONE).getValue());
        return this;
    }

    @Override
    public HybridRunbookWorker refresh(Context context) {
        this.innerObject = (HybridRunbookWorkerInner)((Object)this.serviceManager.serviceClient().getHybridRunbookWorkers().getWithResponse(this.resourceGroupName, this.automationAccountName, this.hybridRunbookWorkerGroupName, this.hybridRunbookWorkerId, context).getValue());
        return this;
    }

    @Override
    public Response<Void> moveWithResponse(HybridRunbookWorkerMoveParameters hybridRunbookWorkerMoveParameters, Context context) {
        return this.serviceManager.hybridRunbookWorkers().moveWithResponse(this.resourceGroupName, this.automationAccountName, this.hybridRunbookWorkerGroupName, this.hybridRunbookWorkerId, hybridRunbookWorkerMoveParameters, context);
    }

    @Override
    public void move(HybridRunbookWorkerMoveParameters hybridRunbookWorkerMoveParameters) {
        this.serviceManager.hybridRunbookWorkers().move(this.resourceGroupName, this.automationAccountName, this.hybridRunbookWorkerGroupName, this.hybridRunbookWorkerId, hybridRunbookWorkerMoveParameters);
    }

    @Override
    public HybridRunbookWorkerImpl withName(String name) {
        this.createHybridRunbookWorkerCreationParameters.withName(name);
        return this;
    }

    @Override
    public HybridRunbookWorkerImpl withVmResourceId(String vmResourceId) {
        this.createHybridRunbookWorkerCreationParameters.withVmResourceId(vmResourceId);
        return this;
    }
}

