/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automation.fluent.HybridRunbookWorkersClient;
import com.azure.resourcemanager.automation.fluent.models.HybridRunbookWorkerInner;
import com.azure.resourcemanager.automation.implementation.AutomationClientImpl;
import com.azure.resourcemanager.automation.models.HybridRunbookWorkerCreateParameters;
import com.azure.resourcemanager.automation.models.HybridRunbookWorkerMoveParameters;
import com.azure.resourcemanager.automation.models.HybridRunbookWorkersListResult;
import reactor.core.publisher.Mono;

public final class HybridRunbookWorkersClientImpl
implements HybridRunbookWorkersClient {
    private final HybridRunbookWorkersService service;
    private final AutomationClientImpl client;

    HybridRunbookWorkersClientImpl(AutomationClientImpl client) {
        this.service = (HybridRunbookWorkersService)RestProxy.create(HybridRunbookWorkersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (hybridRunbookWorkerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerGroupName is required and cannot be null."));
        }
        if (hybridRunbookWorkerId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-06-22";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, this.client.getSubscriptionId(), "2021-06-22", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (hybridRunbookWorkerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerGroupName is required and cannot be null."));
        }
        if (hybridRunbookWorkerId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-06-22";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, this.client.getSubscriptionId(), "2021-06-22", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId) {
        return this.deleteWithResponseAsync(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId) {
        this.deleteWithResponse(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<HybridRunbookWorkerInner>> getWithResponseAsync(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (hybridRunbookWorkerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerGroupName is required and cannot be null."));
        }
        if (hybridRunbookWorkerId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-06-22";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, this.client.getSubscriptionId(), "2021-06-22", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<HybridRunbookWorkerInner>> getWithResponseAsync(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (hybridRunbookWorkerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerGroupName is required and cannot be null."));
        }
        if (hybridRunbookWorkerId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-06-22";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, this.client.getSubscriptionId(), "2021-06-22", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<HybridRunbookWorkerInner> getAsync(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId) {
        return this.getWithResponseAsync(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId).flatMap(res -> Mono.justOrEmpty((Object)((Object)((HybridRunbookWorkerInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<HybridRunbookWorkerInner> getWithResponse(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public HybridRunbookWorkerInner get(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId) {
        return (HybridRunbookWorkerInner)((Object)this.getWithResponse(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<HybridRunbookWorkerInner>> createWithResponseAsync(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId, HybridRunbookWorkerCreateParameters hybridRunbookWorkerCreationParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (hybridRunbookWorkerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerGroupName is required and cannot be null."));
        }
        if (hybridRunbookWorkerId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (hybridRunbookWorkerCreationParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerCreationParameters is required and cannot be null."));
        }
        hybridRunbookWorkerCreationParameters.validate();
        String apiVersion = "2021-06-22";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, this.client.getSubscriptionId(), "2021-06-22", hybridRunbookWorkerCreationParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<HybridRunbookWorkerInner>> createWithResponseAsync(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId, HybridRunbookWorkerCreateParameters hybridRunbookWorkerCreationParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (hybridRunbookWorkerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerGroupName is required and cannot be null."));
        }
        if (hybridRunbookWorkerId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (hybridRunbookWorkerCreationParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerCreationParameters is required and cannot be null."));
        }
        hybridRunbookWorkerCreationParameters.validate();
        String apiVersion = "2021-06-22";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, this.client.getSubscriptionId(), "2021-06-22", hybridRunbookWorkerCreationParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<HybridRunbookWorkerInner> createAsync(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId, HybridRunbookWorkerCreateParameters hybridRunbookWorkerCreationParameters) {
        return this.createWithResponseAsync(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, hybridRunbookWorkerCreationParameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((HybridRunbookWorkerInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<HybridRunbookWorkerInner> createWithResponse(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId, HybridRunbookWorkerCreateParameters hybridRunbookWorkerCreationParameters, Context context) {
        return (Response)this.createWithResponseAsync(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, hybridRunbookWorkerCreationParameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public HybridRunbookWorkerInner create(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId, HybridRunbookWorkerCreateParameters hybridRunbookWorkerCreationParameters) {
        return (HybridRunbookWorkerInner)((Object)this.createWithResponse(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, hybridRunbookWorkerCreationParameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> moveWithResponseAsync(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId, HybridRunbookWorkerMoveParameters hybridRunbookWorkerMoveParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (hybridRunbookWorkerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerGroupName is required and cannot be null."));
        }
        if (hybridRunbookWorkerId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (hybridRunbookWorkerMoveParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerMoveParameters is required and cannot be null."));
        }
        hybridRunbookWorkerMoveParameters.validate();
        String apiVersion = "2021-06-22";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.move(this.client.getEndpoint(), resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, this.client.getSubscriptionId(), "2021-06-22", hybridRunbookWorkerMoveParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> moveWithResponseAsync(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId, HybridRunbookWorkerMoveParameters hybridRunbookWorkerMoveParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (hybridRunbookWorkerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerGroupName is required and cannot be null."));
        }
        if (hybridRunbookWorkerId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (hybridRunbookWorkerMoveParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerMoveParameters is required and cannot be null."));
        }
        hybridRunbookWorkerMoveParameters.validate();
        String apiVersion = "2021-06-22";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.move(this.client.getEndpoint(), resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, this.client.getSubscriptionId(), "2021-06-22", hybridRunbookWorkerMoveParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> moveAsync(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId, HybridRunbookWorkerMoveParameters hybridRunbookWorkerMoveParameters) {
        return this.moveWithResponseAsync(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, hybridRunbookWorkerMoveParameters).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> moveWithResponse(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId, HybridRunbookWorkerMoveParameters hybridRunbookWorkerMoveParameters, Context context) {
        return (Response)this.moveWithResponseAsync(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, hybridRunbookWorkerMoveParameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void move(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId, HybridRunbookWorkerMoveParameters hybridRunbookWorkerMoveParameters) {
        this.moveWithResponse(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, hybridRunbookWorkerMoveParameters, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<HybridRunbookWorkerInner>> listByHybridRunbookWorkerGroupSinglePageAsync(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (hybridRunbookWorkerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-06-22";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByHybridRunbookWorkerGroup(this.client.getEndpoint(), resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, filter, this.client.getSubscriptionId(), "2021-06-22", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HybridRunbookWorkersListResult)res.getValue()).value(), ((HybridRunbookWorkersListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<HybridRunbookWorkerInner>> listByHybridRunbookWorkerGroupSinglePageAsync(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (hybridRunbookWorkerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hybridRunbookWorkerGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-06-22";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByHybridRunbookWorkerGroup(this.client.getEndpoint(), resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, filter, this.client.getSubscriptionId(), "2021-06-22", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HybridRunbookWorkersListResult)res.getValue()).value(), ((HybridRunbookWorkersListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<HybridRunbookWorkerInner> listByHybridRunbookWorkerGroupAsync(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String filter) {
        return new PagedFlux(() -> this.listByHybridRunbookWorkerGroupSinglePageAsync(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, filter), nextLink -> this.listByHybridRunbookWorkerGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<HybridRunbookWorkerInner> listByHybridRunbookWorkerGroupAsync(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName) {
        String filter = null;
        return new PagedFlux(() -> this.listByHybridRunbookWorkerGroupSinglePageAsync(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, filter), nextLink -> this.listByHybridRunbookWorkerGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<HybridRunbookWorkerInner> listByHybridRunbookWorkerGroupAsync(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String filter, Context context) {
        return new PagedFlux(() -> this.listByHybridRunbookWorkerGroupSinglePageAsync(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, filter, context), nextLink -> this.listByHybridRunbookWorkerGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<HybridRunbookWorkerInner> listByHybridRunbookWorkerGroup(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName) {
        String filter = null;
        return new PagedIterable(this.listByHybridRunbookWorkerGroupAsync(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<HybridRunbookWorkerInner> listByHybridRunbookWorkerGroup(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String filter, Context context) {
        return new PagedIterable(this.listByHybridRunbookWorkerGroupAsync(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<HybridRunbookWorkerInner>> listByHybridRunbookWorkerGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByHybridRunbookWorkerGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HybridRunbookWorkersListResult)res.getValue()).value(), ((HybridRunbookWorkersListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<HybridRunbookWorkerInner>> listByHybridRunbookWorkerGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByHybridRunbookWorkerGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HybridRunbookWorkersListResult)res.getValue()).value(), ((HybridRunbookWorkersListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomationClientHybr")
    public static interface HybridRunbookWorkersService {
        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/hybridRunbookWorkerGroups/{hybridRunbookWorkerGroupName}/hybridRunbookWorkers/{hybridRunbookWorkerId}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @PathParam(value="hybridRunbookWorkerGroupName") String var4, @PathParam(value="hybridRunbookWorkerId") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/hybridRunbookWorkerGroups/{hybridRunbookWorkerGroupName}/hybridRunbookWorkers/{hybridRunbookWorkerId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<HybridRunbookWorkerInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @PathParam(value="hybridRunbookWorkerGroupName") String var4, @PathParam(value="hybridRunbookWorkerId") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/hybridRunbookWorkerGroups/{hybridRunbookWorkerGroupName}/hybridRunbookWorkers/{hybridRunbookWorkerId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<HybridRunbookWorkerInner>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @PathParam(value="hybridRunbookWorkerGroupName") String var4, @PathParam(value="hybridRunbookWorkerId") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") HybridRunbookWorkerCreateParameters var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/hybridRunbookWorkerGroups/{hybridRunbookWorkerGroupName}/hybridRunbookWorkers/{hybridRunbookWorkerId}/move")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> move(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @PathParam(value="hybridRunbookWorkerGroupName") String var4, @PathParam(value="hybridRunbookWorkerId") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") HybridRunbookWorkerMoveParameters var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/hybridRunbookWorkerGroups/{hybridRunbookWorkerGroupName}/hybridRunbookWorkers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<HybridRunbookWorkersListResult>> listByHybridRunbookWorkerGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @PathParam(value="hybridRunbookWorkerGroupName") String var4, @QueryParam(value="$filter") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<HybridRunbookWorkersListResult>> listByHybridRunbookWorkerGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

