/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.HybridRunbookWorkersClient;
import com.azure.resourcemanager.automation.fluent.models.HybridRunbookWorkerInner;
import com.azure.resourcemanager.automation.implementation.HybridRunbookWorkerImpl;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.HybridRunbookWorker;
import com.azure.resourcemanager.automation.models.HybridRunbookWorkerMoveParameters;
import com.azure.resourcemanager.automation.models.HybridRunbookWorkers;

public final class HybridRunbookWorkersImpl
implements HybridRunbookWorkers {
    private static final ClientLogger LOGGER = new ClientLogger(HybridRunbookWorkersImpl.class);
    private final HybridRunbookWorkersClient innerClient;
    private final AutomationManager serviceManager;

    public HybridRunbookWorkersImpl(HybridRunbookWorkersClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, context);
    }

    @Override
    public void delete(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId) {
        this.serviceClient().delete(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId);
    }

    @Override
    public Response<HybridRunbookWorker> getWithResponse(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId, Context context) {
        Response<HybridRunbookWorkerInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new HybridRunbookWorkerImpl((HybridRunbookWorkerInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public HybridRunbookWorker get(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId) {
        HybridRunbookWorkerInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId);
        if (inner != null) {
            return new HybridRunbookWorkerImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> moveWithResponse(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId, HybridRunbookWorkerMoveParameters hybridRunbookWorkerMoveParameters, Context context) {
        return this.serviceClient().moveWithResponse(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, hybridRunbookWorkerMoveParameters, context);
    }

    @Override
    public void move(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String hybridRunbookWorkerId, HybridRunbookWorkerMoveParameters hybridRunbookWorkerMoveParameters) {
        this.serviceClient().move(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, hybridRunbookWorkerMoveParameters);
    }

    @Override
    public PagedIterable<HybridRunbookWorker> listByHybridRunbookWorkerGroup(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName) {
        PagedIterable<HybridRunbookWorkerInner> inner = this.serviceClient().listByHybridRunbookWorkerGroup(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new HybridRunbookWorkerImpl((HybridRunbookWorkerInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<HybridRunbookWorker> listByHybridRunbookWorkerGroup(String resourceGroupName, String automationAccountName, String hybridRunbookWorkerGroupName, String filter, Context context) {
        PagedIterable<HybridRunbookWorkerInner> inner = this.serviceClient().listByHybridRunbookWorkerGroup(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new HybridRunbookWorkerImpl((HybridRunbookWorkerInner)((Object)inner1), this.manager()));
    }

    @Override
    public HybridRunbookWorker getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String hybridRunbookWorkerGroupName = ResourceManagerUtils.getValueFromIdByName(id, "hybridRunbookWorkerGroups");
        if (hybridRunbookWorkerGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'hybridRunbookWorkerGroups'.", id)));
        }
        String hybridRunbookWorkerId = ResourceManagerUtils.getValueFromIdByName(id, "hybridRunbookWorkers");
        if (hybridRunbookWorkerId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'hybridRunbookWorkers'.", id)));
        }
        return (HybridRunbookWorker)this.getWithResponse(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, Context.NONE).getValue();
    }

    @Override
    public Response<HybridRunbookWorker> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String hybridRunbookWorkerGroupName = ResourceManagerUtils.getValueFromIdByName(id, "hybridRunbookWorkerGroups");
        if (hybridRunbookWorkerGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'hybridRunbookWorkerGroups'.", id)));
        }
        String hybridRunbookWorkerId = ResourceManagerUtils.getValueFromIdByName(id, "hybridRunbookWorkers");
        if (hybridRunbookWorkerId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'hybridRunbookWorkers'.", id)));
        }
        return this.getWithResponse(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String hybridRunbookWorkerGroupName = ResourceManagerUtils.getValueFromIdByName(id, "hybridRunbookWorkerGroups");
        if (hybridRunbookWorkerGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'hybridRunbookWorkerGroups'.", id)));
        }
        String hybridRunbookWorkerId = ResourceManagerUtils.getValueFromIdByName(id, "hybridRunbookWorkers");
        if (hybridRunbookWorkerId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'hybridRunbookWorkers'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String hybridRunbookWorkerGroupName = ResourceManagerUtils.getValueFromIdByName(id, "hybridRunbookWorkerGroups");
        if (hybridRunbookWorkerGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'hybridRunbookWorkerGroups'.", id)));
        }
        String hybridRunbookWorkerId = ResourceManagerUtils.getValueFromIdByName(id, "hybridRunbookWorkers");
        if (hybridRunbookWorkerId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'hybridRunbookWorkers'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId, context);
    }

    private HybridRunbookWorkersClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public HybridRunbookWorkerImpl define(String name) {
        return new HybridRunbookWorkerImpl(name, this.manager());
    }
}

