/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.JobInner;
import com.azure.resourcemanager.automation.models.Job;
import com.azure.resourcemanager.automation.models.JobCreateParameters;
import com.azure.resourcemanager.automation.models.JobProvisioningState;
import com.azure.resourcemanager.automation.models.JobStatus;
import com.azure.resourcemanager.automation.models.RunbookAssociationProperty;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;

public final class JobImpl
implements Job,
Job.Definition {
    private JobInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private String jobName;
    private String createClientRequestId;
    private JobCreateParameters createParameters;

    JobImpl(JobInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public RunbookAssociationProperty runbook() {
        return this.innerModel().runbook();
    }

    @Override
    public String startedBy() {
        return this.innerModel().startedBy();
    }

    @Override
    public String runOn() {
        return this.innerModel().runOn();
    }

    @Override
    public UUID jobId() {
        return this.innerModel().jobId();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public JobStatus status() {
        return this.innerModel().status();
    }

    @Override
    public String statusDetails() {
        return this.innerModel().statusDetails();
    }

    @Override
    public OffsetDateTime startTime() {
        return this.innerModel().startTime();
    }

    @Override
    public OffsetDateTime endTime() {
        return this.innerModel().endTime();
    }

    @Override
    public String exception() {
        return this.innerModel().exception();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.innerModel().lastModifiedTime();
    }

    @Override
    public OffsetDateTime lastStatusModifiedTime() {
        return this.innerModel().lastStatusModifiedTime();
    }

    @Override
    public Map<String, String> parameters() {
        Map<String, String> inner = this.innerModel().parameters();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public JobProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public JobInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public JobImpl withExistingAutomationAccount(String resourceGroupName, String automationAccountName) {
        this.resourceGroupName = resourceGroupName;
        this.automationAccountName = automationAccountName;
        return this;
    }

    @Override
    public Job create() {
        this.innerObject = (JobInner)((Object)this.serviceManager.serviceClient().getJobs().createWithResponse(this.resourceGroupName, this.automationAccountName, this.jobName, this.createParameters, this.createClientRequestId, Context.NONE).getValue());
        return this;
    }

    @Override
    public Job create(Context context) {
        this.innerObject = (JobInner)((Object)this.serviceManager.serviceClient().getJobs().createWithResponse(this.resourceGroupName, this.automationAccountName, this.jobName, this.createParameters, this.createClientRequestId, context).getValue());
        return this;
    }

    JobImpl(String name, AutomationManager serviceManager) {
        this.innerObject = new JobInner();
        this.serviceManager = serviceManager;
        this.jobName = name;
        this.createClientRequestId = null;
        this.createParameters = new JobCreateParameters();
    }

    @Override
    public Job refresh() {
        String localClientRequestId = null;
        this.innerObject = (JobInner)((Object)this.serviceManager.serviceClient().getJobs().getWithResponse(this.resourceGroupName, this.automationAccountName, this.jobName, localClientRequestId, Context.NONE).getValue());
        return this;
    }

    @Override
    public Job refresh(Context context) {
        String localClientRequestId = null;
        this.innerObject = (JobInner)((Object)this.serviceManager.serviceClient().getJobs().getWithResponse(this.resourceGroupName, this.automationAccountName, this.jobName, localClientRequestId, context).getValue());
        return this;
    }

    @Override
    public Response<Void> suspendWithResponse(String clientRequestId, Context context) {
        return this.serviceManager.jobs().suspendWithResponse(this.resourceGroupName, this.automationAccountName, this.jobName, clientRequestId, context);
    }

    @Override
    public void suspend() {
        this.serviceManager.jobs().suspend(this.resourceGroupName, this.automationAccountName, this.jobName);
    }

    @Override
    public Response<Void> stopWithResponse(String clientRequestId, Context context) {
        return this.serviceManager.jobs().stopWithResponse(this.resourceGroupName, this.automationAccountName, this.jobName, clientRequestId, context);
    }

    @Override
    public void stop() {
        this.serviceManager.jobs().stop(this.resourceGroupName, this.automationAccountName, this.jobName);
    }

    @Override
    public Response<Void> resumeWithResponse(String clientRequestId, Context context) {
        return this.serviceManager.jobs().resumeWithResponse(this.resourceGroupName, this.automationAccountName, this.jobName, clientRequestId, context);
    }

    @Override
    public void resume() {
        this.serviceManager.jobs().resume(this.resourceGroupName, this.automationAccountName, this.jobName);
    }

    @Override
    public JobImpl withRunbook(RunbookAssociationProperty runbook) {
        this.createParameters.withRunbook(runbook);
        return this;
    }

    @Override
    public JobImpl withParameters(Map<String, String> parameters) {
        this.createParameters.withParameters(parameters);
        return this;
    }

    @Override
    public JobImpl withRunOn(String runOn) {
        this.createParameters.withRunOn(runOn);
        return this;
    }

    @Override
    public JobImpl withClientRequestId(String clientRequestId) {
        this.createClientRequestId = clientRequestId;
        return this;
    }
}

