/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.JobScheduleInner;
import com.azure.resourcemanager.automation.models.JobSchedule;
import com.azure.resourcemanager.automation.models.JobScheduleCreateParameters;
import com.azure.resourcemanager.automation.models.RunbookAssociationProperty;
import com.azure.resourcemanager.automation.models.ScheduleAssociationProperty;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;

public final class JobScheduleImpl
implements JobSchedule,
JobSchedule.Definition {
    private JobScheduleInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private UUID jobScheduleId;
    private JobScheduleCreateParameters createParameters;

    JobScheduleImpl(JobScheduleInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String jobScheduleId() {
        return this.innerModel().jobScheduleId();
    }

    @Override
    public ScheduleAssociationProperty schedule() {
        return this.innerModel().schedule();
    }

    @Override
    public RunbookAssociationProperty runbook() {
        return this.innerModel().runbook();
    }

    @Override
    public String runOn() {
        return this.innerModel().runOn();
    }

    @Override
    public Map<String, String> parameters() {
        Map<String, String> inner = this.innerModel().parameters();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public JobScheduleInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public JobScheduleImpl withExistingAutomationAccount(String resourceGroupName, String automationAccountName) {
        this.resourceGroupName = resourceGroupName;
        this.automationAccountName = automationAccountName;
        return this;
    }

    @Override
    public JobSchedule create() {
        this.innerObject = (JobScheduleInner)this.serviceManager.serviceClient().getJobSchedules().createWithResponse(this.resourceGroupName, this.automationAccountName, this.jobScheduleId, this.createParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public JobSchedule create(Context context) {
        this.innerObject = (JobScheduleInner)this.serviceManager.serviceClient().getJobSchedules().createWithResponse(this.resourceGroupName, this.automationAccountName, this.jobScheduleId, this.createParameters, context).getValue();
        return this;
    }

    JobScheduleImpl(UUID name, AutomationManager serviceManager) {
        this.innerObject = new JobScheduleInner();
        this.serviceManager = serviceManager;
        this.jobScheduleId = name;
        this.createParameters = new JobScheduleCreateParameters();
    }

    @Override
    public JobSchedule refresh() {
        this.innerObject = (JobScheduleInner)this.serviceManager.serviceClient().getJobSchedules().getWithResponse(this.resourceGroupName, this.automationAccountName, this.jobScheduleId, Context.NONE).getValue();
        return this;
    }

    @Override
    public JobSchedule refresh(Context context) {
        this.innerObject = (JobScheduleInner)this.serviceManager.serviceClient().getJobSchedules().getWithResponse(this.resourceGroupName, this.automationAccountName, this.jobScheduleId, context).getValue();
        return this;
    }

    @Override
    public JobScheduleImpl withSchedule(ScheduleAssociationProperty schedule) {
        this.createParameters.withSchedule(schedule);
        return this;
    }

    @Override
    public JobScheduleImpl withRunbook(RunbookAssociationProperty runbook) {
        this.createParameters.withRunbook(runbook);
        return this;
    }

    @Override
    public JobScheduleImpl withRunOn(String runOn) {
        this.createParameters.withRunOn(runOn);
        return this;
    }

    @Override
    public JobScheduleImpl withParameters(Map<String, String> parameters) {
        this.createParameters.withParameters(parameters);
        return this;
    }
}

