/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.JobSchedulesClient;
import com.azure.resourcemanager.automation.fluent.models.JobScheduleInner;
import com.azure.resourcemanager.automation.implementation.JobScheduleImpl;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.JobSchedule;
import com.azure.resourcemanager.automation.models.JobSchedules;
import java.util.UUID;

public final class JobSchedulesImpl
implements JobSchedules {
    private static final ClientLogger LOGGER = new ClientLogger(JobSchedulesImpl.class);
    private final JobSchedulesClient innerClient;
    private final AutomationManager serviceManager;

    public JobSchedulesImpl(JobSchedulesClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String automationAccountName, UUID jobScheduleId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, automationAccountName, jobScheduleId, context);
    }

    @Override
    public void delete(String resourceGroupName, String automationAccountName, UUID jobScheduleId) {
        this.serviceClient().delete(resourceGroupName, automationAccountName, jobScheduleId);
    }

    @Override
    public Response<JobSchedule> getWithResponse(String resourceGroupName, String automationAccountName, UUID jobScheduleId, Context context) {
        Response<JobScheduleInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, jobScheduleId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new JobScheduleImpl((JobScheduleInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public JobSchedule get(String resourceGroupName, String automationAccountName, UUID jobScheduleId) {
        JobScheduleInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, jobScheduleId);
        if (inner != null) {
            return new JobScheduleImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<JobSchedule> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        PagedIterable<JobScheduleInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JobScheduleImpl((JobScheduleInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<JobSchedule> listByAutomationAccount(String resourceGroupName, String automationAccountName, String filter, Context context) {
        PagedIterable<JobScheduleInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JobScheduleImpl((JobScheduleInner)inner1, this.manager()));
    }

    @Override
    public JobSchedule getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String jobScheduleIdLocal = ResourceManagerUtils.getValueFromIdByName(id, "jobSchedules");
        if (jobScheduleIdLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'jobSchedules'.", id)));
        }
        UUID jobScheduleId = UUID.fromString(jobScheduleIdLocal);
        return (JobSchedule)this.getWithResponse(resourceGroupName, automationAccountName, jobScheduleId, Context.NONE).getValue();
    }

    @Override
    public Response<JobSchedule> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String jobScheduleIdLocal = ResourceManagerUtils.getValueFromIdByName(id, "jobSchedules");
        if (jobScheduleIdLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'jobSchedules'.", id)));
        }
        UUID jobScheduleId = UUID.fromString(jobScheduleIdLocal);
        return this.getWithResponse(resourceGroupName, automationAccountName, jobScheduleId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String jobScheduleIdLocal = ResourceManagerUtils.getValueFromIdByName(id, "jobSchedules");
        if (jobScheduleIdLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'jobSchedules'.", id)));
        }
        UUID jobScheduleId = UUID.fromString(jobScheduleIdLocal);
        this.deleteWithResponse(resourceGroupName, automationAccountName, jobScheduleId, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String jobScheduleIdLocal = ResourceManagerUtils.getValueFromIdByName(id, "jobSchedules");
        if (jobScheduleIdLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'jobSchedules'.", id)));
        }
        UUID jobScheduleId = UUID.fromString(jobScheduleIdLocal);
        return this.deleteWithResponse(resourceGroupName, automationAccountName, jobScheduleId, context);
    }

    private JobSchedulesClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public JobScheduleImpl define(UUID name) {
        return new JobScheduleImpl(name, this.manager());
    }
}

