/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automation.fluent.JobStreamsClient;
import com.azure.resourcemanager.automation.fluent.models.JobStreamInner;
import com.azure.resourcemanager.automation.fluent.models.JobStreamListResultInner;
import com.azure.resourcemanager.automation.implementation.AutomationClientImpl;
import reactor.core.publisher.Mono;

public final class JobStreamsClientImpl
implements JobStreamsClient {
    private final JobStreamsService service;
    private final AutomationClientImpl client;

    JobStreamsClientImpl(AutomationClientImpl client) {
        this.service = (JobStreamsService)RestProxy.create(JobStreamsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JobStreamInner>> getWithResponseAsync(String resourceGroupName, String automationAccountName, String jobName, String jobStreamId, String clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobStreamId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobStreamId is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, jobName, jobStreamId, "2019-06-01", clientRequestId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JobStreamInner>> getWithResponseAsync(String resourceGroupName, String automationAccountName, String jobName, String jobStreamId, String clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobStreamId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobStreamId is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, jobName, jobStreamId, "2019-06-01", clientRequestId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<JobStreamInner> getAsync(String resourceGroupName, String automationAccountName, String jobName, String jobStreamId) {
        String clientRequestId = null;
        return this.getWithResponseAsync(resourceGroupName, automationAccountName, jobName, jobStreamId, clientRequestId).flatMap(res -> Mono.justOrEmpty((Object)((JobStreamInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<JobStreamInner> getWithResponse(String resourceGroupName, String automationAccountName, String jobName, String jobStreamId, String clientRequestId, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, automationAccountName, jobName, jobStreamId, clientRequestId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JobStreamInner get(String resourceGroupName, String automationAccountName, String jobName, String jobStreamId) {
        String clientRequestId = null;
        return (JobStreamInner)this.getWithResponse(resourceGroupName, automationAccountName, jobName, jobStreamId, clientRequestId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobStreamInner>> listByJobSinglePageAsync(String resourceGroupName, String automationAccountName, String jobName, String filter, String clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByJob(this.client.getEndpoint(), resourceGroupName, automationAccountName, jobName, filter, this.client.getSubscriptionId(), "2019-06-01", clientRequestId, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobStreamListResultInner)res.getValue()).value(), ((JobStreamListResultInner)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobStreamInner>> listByJobSinglePageAsync(String resourceGroupName, String automationAccountName, String jobName, String filter, String clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByJob(this.client.getEndpoint(), resourceGroupName, automationAccountName, jobName, filter, this.client.getSubscriptionId(), "2019-06-01", clientRequestId, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobStreamListResultInner)res.getValue()).value(), ((JobStreamListResultInner)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JobStreamInner> listByJobAsync(String resourceGroupName, String automationAccountName, String jobName, String filter, String clientRequestId) {
        return new PagedFlux(() -> this.listByJobSinglePageAsync(resourceGroupName, automationAccountName, jobName, filter, clientRequestId), nextLink -> this.listByJobNextSinglePageAsync((String)nextLink, clientRequestId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JobStreamInner> listByJobAsync(String resourceGroupName, String automationAccountName, String jobName) {
        String filter = null;
        String clientRequestId = null;
        return new PagedFlux(() -> this.listByJobSinglePageAsync(resourceGroupName, automationAccountName, jobName, filter, clientRequestId), nextLink -> this.listByJobNextSinglePageAsync((String)nextLink, clientRequestId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JobStreamInner> listByJobAsync(String resourceGroupName, String automationAccountName, String jobName, String filter, String clientRequestId, Context context) {
        return new PagedFlux(() -> this.listByJobSinglePageAsync(resourceGroupName, automationAccountName, jobName, filter, clientRequestId, context), nextLink -> this.listByJobNextSinglePageAsync((String)nextLink, clientRequestId, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JobStreamInner> listByJob(String resourceGroupName, String automationAccountName, String jobName) {
        String filter = null;
        String clientRequestId = null;
        return new PagedIterable(this.listByJobAsync(resourceGroupName, automationAccountName, jobName, filter, clientRequestId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JobStreamInner> listByJob(String resourceGroupName, String automationAccountName, String jobName, String filter, String clientRequestId, Context context) {
        return new PagedIterable(this.listByJobAsync(resourceGroupName, automationAccountName, jobName, filter, clientRequestId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobStreamInner>> listByJobNextSinglePageAsync(String nextLink, String clientRequestId) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByJobNext(nextLink, this.client.getEndpoint(), clientRequestId, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobStreamListResultInner)res.getValue()).value(), ((JobStreamListResultInner)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobStreamInner>> listByJobNextSinglePageAsync(String nextLink, String clientRequestId, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByJobNext(nextLink, this.client.getEndpoint(), clientRequestId, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobStreamListResultInner)res.getValue()).value(), ((JobStreamListResultInner)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomationClientJobS")
    public static interface JobStreamsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/jobs/{jobName}/streams/{jobStreamId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobStreamInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="jobName") String var5, @PathParam(value="jobStreamId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="clientRequestId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/jobs/{jobName}/streams")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobStreamListResultInner>> listByJob(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @PathParam(value="jobName") String var4, @QueryParam(value="$filter") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="clientRequestId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobStreamListResultInner>> listByJobNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="clientRequestId") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

