/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.JobStreamsClient;
import com.azure.resourcemanager.automation.fluent.models.JobStreamInner;
import com.azure.resourcemanager.automation.implementation.JobStreamImpl;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.JobStream;
import com.azure.resourcemanager.automation.models.JobStreams;

public final class JobStreamsImpl
implements JobStreams {
    private static final ClientLogger LOGGER = new ClientLogger(JobStreamsImpl.class);
    private final JobStreamsClient innerClient;
    private final AutomationManager serviceManager;

    public JobStreamsImpl(JobStreamsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<JobStream> getWithResponse(String resourceGroupName, String automationAccountName, String jobName, String jobStreamId, String clientRequestId, Context context) {
        Response<JobStreamInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, jobName, jobStreamId, clientRequestId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new JobStreamImpl((JobStreamInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public JobStream get(String resourceGroupName, String automationAccountName, String jobName, String jobStreamId) {
        JobStreamInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, jobName, jobStreamId);
        if (inner != null) {
            return new JobStreamImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<JobStream> listByJob(String resourceGroupName, String automationAccountName, String jobName) {
        PagedIterable<JobStreamInner> inner = this.serviceClient().listByJob(resourceGroupName, automationAccountName, jobName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JobStreamImpl((JobStreamInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<JobStream> listByJob(String resourceGroupName, String automationAccountName, String jobName, String filter, String clientRequestId, Context context) {
        PagedIterable<JobStreamInner> inner = this.serviceClient().listByJob(resourceGroupName, automationAccountName, jobName, filter, clientRequestId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JobStreamImpl((JobStreamInner)inner1, this.manager()));
    }

    private JobStreamsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }
}

