/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.JobsClient;
import com.azure.resourcemanager.automation.fluent.models.JobCollectionItemInner;
import com.azure.resourcemanager.automation.fluent.models.JobInner;
import com.azure.resourcemanager.automation.implementation.JobCollectionItemImpl;
import com.azure.resourcemanager.automation.implementation.JobImpl;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.Job;
import com.azure.resourcemanager.automation.models.JobCollectionItem;
import com.azure.resourcemanager.automation.models.Jobs;

public final class JobsImpl
implements Jobs {
    private static final ClientLogger LOGGER = new ClientLogger(JobsImpl.class);
    private final JobsClient innerClient;
    private final AutomationManager serviceManager;

    public JobsImpl(JobsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<String> getOutputWithResponse(String resourceGroupName, String automationAccountName, String jobName, String clientRequestId, Context context) {
        return this.serviceClient().getOutputWithResponse(resourceGroupName, automationAccountName, jobName, clientRequestId, context);
    }

    @Override
    public String getOutput(String resourceGroupName, String automationAccountName, String jobName) {
        return this.serviceClient().getOutput(resourceGroupName, automationAccountName, jobName);
    }

    @Override
    public Response<String> getRunbookContentWithResponse(String resourceGroupName, String automationAccountName, String jobName, String clientRequestId, Context context) {
        return this.serviceClient().getRunbookContentWithResponse(resourceGroupName, automationAccountName, jobName, clientRequestId, context);
    }

    @Override
    public String getRunbookContent(String resourceGroupName, String automationAccountName, String jobName) {
        return this.serviceClient().getRunbookContent(resourceGroupName, automationAccountName, jobName);
    }

    @Override
    public Response<Void> suspendWithResponse(String resourceGroupName, String automationAccountName, String jobName, String clientRequestId, Context context) {
        return this.serviceClient().suspendWithResponse(resourceGroupName, automationAccountName, jobName, clientRequestId, context);
    }

    @Override
    public void suspend(String resourceGroupName, String automationAccountName, String jobName) {
        this.serviceClient().suspend(resourceGroupName, automationAccountName, jobName);
    }

    @Override
    public Response<Void> stopWithResponse(String resourceGroupName, String automationAccountName, String jobName, String clientRequestId, Context context) {
        return this.serviceClient().stopWithResponse(resourceGroupName, automationAccountName, jobName, clientRequestId, context);
    }

    @Override
    public void stop(String resourceGroupName, String automationAccountName, String jobName) {
        this.serviceClient().stop(resourceGroupName, automationAccountName, jobName);
    }

    @Override
    public Response<Job> getWithResponse(String resourceGroupName, String automationAccountName, String jobName, String clientRequestId, Context context) {
        Response<JobInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, jobName, clientRequestId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new JobImpl((JobInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Job get(String resourceGroupName, String automationAccountName, String jobName) {
        JobInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, jobName);
        if (inner != null) {
            return new JobImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<JobCollectionItem> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        PagedIterable<JobCollectionItemInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JobCollectionItemImpl((JobCollectionItemInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<JobCollectionItem> listByAutomationAccount(String resourceGroupName, String automationAccountName, String filter, String clientRequestId, Context context) {
        PagedIterable<JobCollectionItemInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, filter, clientRequestId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JobCollectionItemImpl((JobCollectionItemInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Void> resumeWithResponse(String resourceGroupName, String automationAccountName, String jobName, String clientRequestId, Context context) {
        return this.serviceClient().resumeWithResponse(resourceGroupName, automationAccountName, jobName, clientRequestId, context);
    }

    @Override
    public void resume(String resourceGroupName, String automationAccountName, String jobName) {
        this.serviceClient().resume(resourceGroupName, automationAccountName, jobName);
    }

    @Override
    public Job getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String jobName = ResourceManagerUtils.getValueFromIdByName(id, "jobs");
        if (jobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'jobs'.", id)));
        }
        String localClientRequestId = null;
        return (Job)this.getWithResponse(resourceGroupName, automationAccountName, jobName, localClientRequestId, Context.NONE).getValue();
    }

    @Override
    public Response<Job> getByIdWithResponse(String id, String clientRequestId, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String jobName = ResourceManagerUtils.getValueFromIdByName(id, "jobs");
        if (jobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'jobs'.", id)));
        }
        return this.getWithResponse(resourceGroupName, automationAccountName, jobName, clientRequestId, context);
    }

    private JobsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public JobImpl define(String name) {
        return new JobImpl(name, this.manager());
    }
}

