/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automation.fluent.KeysClient;
import com.azure.resourcemanager.automation.fluent.models.KeyListResultInner;
import com.azure.resourcemanager.automation.implementation.AutomationClientImpl;
import reactor.core.publisher.Mono;

public final class KeysClientImpl
implements KeysClient {
    private final KeysService service;
    private final AutomationClientImpl client;

    KeysClientImpl(AutomationClientImpl client) {
        this.service = (KeysService)RestProxy.create(KeysService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<KeyListResultInner>> listByAutomationAccountWithResponseAsync(String resourceGroupName, String automationAccountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-06-22";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByAutomationAccount(this.client.getEndpoint(), resourceGroupName, automationAccountName, this.client.getSubscriptionId(), "2021-06-22", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<KeyListResultInner>> listByAutomationAccountWithResponseAsync(String resourceGroupName, String automationAccountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-06-22";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByAutomationAccount(this.client.getEndpoint(), resourceGroupName, automationAccountName, this.client.getSubscriptionId(), "2021-06-22", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<KeyListResultInner> listByAutomationAccountAsync(String resourceGroupName, String automationAccountName) {
        return this.listByAutomationAccountWithResponseAsync(resourceGroupName, automationAccountName).flatMap(res -> Mono.justOrEmpty((Object)((KeyListResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyListResultInner> listByAutomationAccountWithResponse(String resourceGroupName, String automationAccountName, Context context) {
        return (Response)this.listByAutomationAccountWithResponseAsync(resourceGroupName, automationAccountName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyListResultInner listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        return (KeyListResultInner)this.listByAutomationAccountWithResponse(resourceGroupName, automationAccountName, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomationClientKeys")
    public static interface KeysService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/listKeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<KeyListResultInner>> listByAutomationAccount(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

