/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.KeysClient;
import com.azure.resourcemanager.automation.fluent.models.KeyListResultInner;
import com.azure.resourcemanager.automation.implementation.KeyListResultImpl;
import com.azure.resourcemanager.automation.models.KeyListResult;
import com.azure.resourcemanager.automation.models.Keys;

public final class KeysImpl
implements Keys {
    private static final ClientLogger LOGGER = new ClientLogger(KeysImpl.class);
    private final KeysClient innerClient;
    private final AutomationManager serviceManager;

    public KeysImpl(KeysClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<KeyListResult> listByAutomationAccountWithResponse(String resourceGroupName, String automationAccountName, Context context) {
        Response<KeyListResultInner> inner = this.serviceClient().listByAutomationAccountWithResponse(resourceGroupName, automationAccountName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new KeyListResultImpl((KeyListResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public KeyListResult listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        KeyListResultInner inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName);
        if (inner != null) {
            return new KeyListResultImpl(inner, this.manager());
        }
        return null;
    }

    private KeysClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }
}

