/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.LinkedWorkspacesClient;
import com.azure.resourcemanager.automation.fluent.models.LinkedWorkspaceInner;
import com.azure.resourcemanager.automation.implementation.LinkedWorkspaceImpl;
import com.azure.resourcemanager.automation.models.LinkedWorkspace;
import com.azure.resourcemanager.automation.models.LinkedWorkspaces;

public final class LinkedWorkspacesImpl
implements LinkedWorkspaces {
    private static final ClientLogger LOGGER = new ClientLogger(LinkedWorkspacesImpl.class);
    private final LinkedWorkspacesClient innerClient;
    private final AutomationManager serviceManager;

    public LinkedWorkspacesImpl(LinkedWorkspacesClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<LinkedWorkspace> getWithResponse(String resourceGroupName, String automationAccountName, Context context) {
        Response<LinkedWorkspaceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new LinkedWorkspaceImpl((LinkedWorkspaceInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public LinkedWorkspace get(String resourceGroupName, String automationAccountName) {
        LinkedWorkspaceInner inner = this.serviceClient().get(resourceGroupName, automationAccountName);
        if (inner != null) {
            return new LinkedWorkspaceImpl(inner, this.manager());
        }
        return null;
    }

    private LinkedWorkspacesClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }
}

