/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.ModuleInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.ContentLink;
import com.azure.resourcemanager.automation.models.Module;
import com.azure.resourcemanager.automation.models.ModuleErrorInfo;
import com.azure.resourcemanager.automation.models.ModuleProvisioningState;
import com.azure.resourcemanager.automation.models.PythonPackageCreateParameters;
import com.azure.resourcemanager.automation.models.PythonPackageUpdateParameters;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;

public final class ModuleImpl
implements Module,
Module.Definition,
Module.Update {
    private ModuleInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private String packageName;
    private PythonPackageCreateParameters createParameters;
    private PythonPackageUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public Boolean isGlobal() {
        return this.innerModel().isGlobal();
    }

    @Override
    public String version() {
        return this.innerModel().version();
    }

    @Override
    public Long sizeInBytes() {
        return this.innerModel().sizeInBytes();
    }

    @Override
    public Integer activityCount() {
        return this.innerModel().activityCount();
    }

    @Override
    public ModuleProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public ContentLink contentLink() {
        return this.innerModel().contentLink();
    }

    @Override
    public ModuleErrorInfo error() {
        return this.innerModel().error();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.innerModel().lastModifiedTime();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public Boolean isComposite() {
        return this.innerModel().isComposite();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ModuleInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ModuleImpl withExistingAutomationAccount(String resourceGroupName, String automationAccountName) {
        this.resourceGroupName = resourceGroupName;
        this.automationAccountName = automationAccountName;
        return this;
    }

    @Override
    public Module create() {
        this.innerObject = (ModuleInner)((Object)this.serviceManager.serviceClient().getPython2Packages().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.packageName, this.createParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Module create(Context context) {
        this.innerObject = (ModuleInner)((Object)this.serviceManager.serviceClient().getPython2Packages().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.packageName, this.createParameters, context).getValue());
        return this;
    }

    ModuleImpl(String name, AutomationManager serviceManager) {
        this.innerObject = new ModuleInner();
        this.serviceManager = serviceManager;
        this.packageName = name;
        this.createParameters = new PythonPackageCreateParameters();
    }

    @Override
    public ModuleImpl update() {
        this.updateParameters = new PythonPackageUpdateParameters();
        return this;
    }

    @Override
    public Module apply() {
        this.innerObject = (ModuleInner)((Object)this.serviceManager.serviceClient().getPython2Packages().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.packageName, this.updateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Module apply(Context context) {
        this.innerObject = (ModuleInner)((Object)this.serviceManager.serviceClient().getPython2Packages().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.packageName, this.updateParameters, context).getValue());
        return this;
    }

    ModuleImpl(ModuleInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.automationAccountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "automationAccounts");
        this.packageName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "python2Packages");
    }

    @Override
    public Module refresh() {
        this.innerObject = (ModuleInner)((Object)this.serviceManager.serviceClient().getPython2Packages().getWithResponse(this.resourceGroupName, this.automationAccountName, this.packageName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Module refresh(Context context) {
        this.innerObject = (ModuleInner)((Object)this.serviceManager.serviceClient().getPython2Packages().getWithResponse(this.resourceGroupName, this.automationAccountName, this.packageName, context).getValue());
        return this;
    }

    @Override
    public ModuleImpl withContentLink(ContentLink contentLink) {
        this.createParameters.withContentLink(contentLink);
        return this;
    }

    @Override
    public ModuleImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.createParameters.withTags(tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

