/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automation.fluent.NodeCountInformationsClient;
import com.azure.resourcemanager.automation.fluent.models.NodeCountsInner;
import com.azure.resourcemanager.automation.implementation.AutomationClientImpl;
import com.azure.resourcemanager.automation.models.CountType;
import reactor.core.publisher.Mono;

public final class NodeCountInformationsClientImpl
implements NodeCountInformationsClient {
    private final NodeCountInformationsService service;
    private final AutomationClientImpl client;

    NodeCountInformationsClientImpl(AutomationClientImpl client) {
        this.service = (NodeCountInformationsService)RestProxy.create(NodeCountInformationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NodeCountsInner>> getWithResponseAsync(String resourceGroupName, String automationAccountName, CountType countType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (countType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter countType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, automationAccountName, countType, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NodeCountsInner>> getWithResponseAsync(String resourceGroupName, String automationAccountName, CountType countType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (countType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter countType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, automationAccountName, countType, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NodeCountsInner> getAsync(String resourceGroupName, String automationAccountName, CountType countType) {
        return this.getWithResponseAsync(resourceGroupName, automationAccountName, countType).flatMap(res -> Mono.justOrEmpty((Object)((NodeCountsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NodeCountsInner> getWithResponse(String resourceGroupName, String automationAccountName, CountType countType, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, automationAccountName, countType, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NodeCountsInner get(String resourceGroupName, String automationAccountName, CountType countType) {
        return (NodeCountsInner)this.getWithResponse(resourceGroupName, automationAccountName, countType, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomationClientNode")
    public static interface NodeCountInformationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/nodecounts/{countType}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NodeCountsInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @PathParam(value="countType") CountType var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

