/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.NodeCountInformationsClient;
import com.azure.resourcemanager.automation.fluent.models.NodeCountsInner;
import com.azure.resourcemanager.automation.implementation.NodeCountsImpl;
import com.azure.resourcemanager.automation.models.CountType;
import com.azure.resourcemanager.automation.models.NodeCountInformations;
import com.azure.resourcemanager.automation.models.NodeCounts;

public final class NodeCountInformationsImpl
implements NodeCountInformations {
    private static final ClientLogger LOGGER = new ClientLogger(NodeCountInformationsImpl.class);
    private final NodeCountInformationsClient innerClient;
    private final AutomationManager serviceManager;

    public NodeCountInformationsImpl(NodeCountInformationsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<NodeCounts> getWithResponse(String resourceGroupName, String automationAccountName, CountType countType, Context context) {
        Response<NodeCountsInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, countType, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NodeCountsImpl((NodeCountsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public NodeCounts get(String resourceGroupName, String automationAccountName, CountType countType) {
        NodeCountsInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, countType);
        if (inner != null) {
            return new NodeCountsImpl(inner, this.manager());
        }
        return null;
    }

    private NodeCountInformationsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }
}

