/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.NodeReportsClient;
import com.azure.resourcemanager.automation.fluent.models.DscNodeReportInner;
import com.azure.resourcemanager.automation.implementation.DscNodeReportImpl;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.DscNodeReport;
import com.azure.resourcemanager.automation.models.NodeReports;

public final class NodeReportsImpl
implements NodeReports {
    private static final ClientLogger LOGGER = new ClientLogger(NodeReportsImpl.class);
    private final NodeReportsClient innerClient;
    private final AutomationManager serviceManager;

    public NodeReportsImpl(NodeReportsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<DscNodeReport> listByNode(String resourceGroupName, String automationAccountName, String nodeId) {
        PagedIterable<DscNodeReportInner> inner = this.serviceClient().listByNode(resourceGroupName, automationAccountName, nodeId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DscNodeReportImpl((DscNodeReportInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<DscNodeReport> listByNode(String resourceGroupName, String automationAccountName, String nodeId, String filter, Context context) {
        PagedIterable<DscNodeReportInner> inner = this.serviceClient().listByNode(resourceGroupName, automationAccountName, nodeId, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DscNodeReportImpl((DscNodeReportInner)inner1, this.manager()));
    }

    @Override
    public Response<DscNodeReport> getWithResponse(String resourceGroupName, String automationAccountName, String nodeId, String reportId, Context context) {
        Response<DscNodeReportInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, nodeId, reportId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DscNodeReportImpl((DscNodeReportInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DscNodeReport get(String resourceGroupName, String automationAccountName, String nodeId, String reportId) {
        DscNodeReportInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, nodeId, reportId);
        if (inner != null) {
            return new DscNodeReportImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Object> getContentWithResponse(String resourceGroupName, String automationAccountName, String nodeId, String reportId, Context context) {
        return this.serviceClient().getContentWithResponse(resourceGroupName, automationAccountName, nodeId, reportId, context);
    }

    @Override
    public Object getContent(String resourceGroupName, String automationAccountName, String nodeId, String reportId) {
        return this.serviceClient().getContent(resourceGroupName, automationAccountName, nodeId, reportId);
    }

    private NodeReportsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }
}

