/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automation.fluent.ObjectDataTypesClient;
import com.azure.resourcemanager.automation.fluent.models.TypeFieldInner;
import com.azure.resourcemanager.automation.implementation.AutomationClientImpl;
import com.azure.resourcemanager.automation.models.TypeFieldListResult;
import reactor.core.publisher.Mono;

public final class ObjectDataTypesClientImpl
implements ObjectDataTypesClient {
    private final ObjectDataTypesService service;
    private final AutomationClientImpl client;

    ObjectDataTypesClientImpl(AutomationClientImpl client) {
        this.service = (ObjectDataTypesService)RestProxy.create(ObjectDataTypesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TypeFieldInner>> listFieldsByModuleAndTypeSinglePageAsync(String resourceGroupName, String automationAccountName, String moduleName, String typeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (moduleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter moduleName is required and cannot be null."));
        }
        if (typeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter typeName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listFieldsByModuleAndType(this.client.getEndpoint(), resourceGroupName, automationAccountName, moduleName, typeName, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TypeFieldListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TypeFieldInner>> listFieldsByModuleAndTypeSinglePageAsync(String resourceGroupName, String automationAccountName, String moduleName, String typeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (moduleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter moduleName is required and cannot be null."));
        }
        if (typeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter typeName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listFieldsByModuleAndType(this.client.getEndpoint(), resourceGroupName, automationAccountName, moduleName, typeName, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TypeFieldListResult)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TypeFieldInner> listFieldsByModuleAndTypeAsync(String resourceGroupName, String automationAccountName, String moduleName, String typeName) {
        return new PagedFlux(() -> this.listFieldsByModuleAndTypeSinglePageAsync(resourceGroupName, automationAccountName, moduleName, typeName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TypeFieldInner> listFieldsByModuleAndTypeAsync(String resourceGroupName, String automationAccountName, String moduleName, String typeName, Context context) {
        return new PagedFlux(() -> this.listFieldsByModuleAndTypeSinglePageAsync(resourceGroupName, automationAccountName, moduleName, typeName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TypeFieldInner> listFieldsByModuleAndType(String resourceGroupName, String automationAccountName, String moduleName, String typeName) {
        return new PagedIterable(this.listFieldsByModuleAndTypeAsync(resourceGroupName, automationAccountName, moduleName, typeName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TypeFieldInner> listFieldsByModuleAndType(String resourceGroupName, String automationAccountName, String moduleName, String typeName, Context context) {
        return new PagedIterable(this.listFieldsByModuleAndTypeAsync(resourceGroupName, automationAccountName, moduleName, typeName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TypeFieldInner>> listFieldsByTypeSinglePageAsync(String resourceGroupName, String automationAccountName, String typeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (typeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter typeName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listFieldsByType(this.client.getEndpoint(), resourceGroupName, automationAccountName, typeName, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TypeFieldListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TypeFieldInner>> listFieldsByTypeSinglePageAsync(String resourceGroupName, String automationAccountName, String typeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (typeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter typeName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listFieldsByType(this.client.getEndpoint(), resourceGroupName, automationAccountName, typeName, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TypeFieldListResult)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TypeFieldInner> listFieldsByTypeAsync(String resourceGroupName, String automationAccountName, String typeName) {
        return new PagedFlux(() -> this.listFieldsByTypeSinglePageAsync(resourceGroupName, automationAccountName, typeName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TypeFieldInner> listFieldsByTypeAsync(String resourceGroupName, String automationAccountName, String typeName, Context context) {
        return new PagedFlux(() -> this.listFieldsByTypeSinglePageAsync(resourceGroupName, automationAccountName, typeName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TypeFieldInner> listFieldsByType(String resourceGroupName, String automationAccountName, String typeName) {
        return new PagedIterable(this.listFieldsByTypeAsync(resourceGroupName, automationAccountName, typeName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TypeFieldInner> listFieldsByType(String resourceGroupName, String automationAccountName, String typeName, Context context) {
        return new PagedIterable(this.listFieldsByTypeAsync(resourceGroupName, automationAccountName, typeName, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomationClientObje")
    public static interface ObjectDataTypesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/modules/{moduleName}/objectDataTypes/{typeName}/fields")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TypeFieldListResult>> listFieldsByModuleAndType(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @PathParam(value="moduleName") String var4, @PathParam(value="typeName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/objectDataTypes/{typeName}/fields")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TypeFieldListResult>> listFieldsByType(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @PathParam(value="typeName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

