/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.ObjectDataTypesClient;
import com.azure.resourcemanager.automation.fluent.models.TypeFieldInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.implementation.TypeFieldImpl;
import com.azure.resourcemanager.automation.models.ObjectDataTypes;
import com.azure.resourcemanager.automation.models.TypeField;

public final class ObjectDataTypesImpl
implements ObjectDataTypes {
    private static final ClientLogger LOGGER = new ClientLogger(ObjectDataTypesImpl.class);
    private final ObjectDataTypesClient innerClient;
    private final AutomationManager serviceManager;

    public ObjectDataTypesImpl(ObjectDataTypesClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<TypeField> listFieldsByModuleAndType(String resourceGroupName, String automationAccountName, String moduleName, String typeName) {
        PagedIterable<TypeFieldInner> inner = this.serviceClient().listFieldsByModuleAndType(resourceGroupName, automationAccountName, moduleName, typeName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TypeFieldImpl((TypeFieldInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<TypeField> listFieldsByModuleAndType(String resourceGroupName, String automationAccountName, String moduleName, String typeName, Context context) {
        PagedIterable<TypeFieldInner> inner = this.serviceClient().listFieldsByModuleAndType(resourceGroupName, automationAccountName, moduleName, typeName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TypeFieldImpl((TypeFieldInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<TypeField> listFieldsByType(String resourceGroupName, String automationAccountName, String typeName) {
        PagedIterable<TypeFieldInner> inner = this.serviceClient().listFieldsByType(resourceGroupName, automationAccountName, typeName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TypeFieldImpl((TypeFieldInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<TypeField> listFieldsByType(String resourceGroupName, String automationAccountName, String typeName, Context context) {
        PagedIterable<TypeFieldInner> inner = this.serviceClient().listFieldsByType(resourceGroupName, automationAccountName, typeName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TypeFieldImpl((TypeFieldInner)inner1, this.manager()));
    }

    private ObjectDataTypesClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }
}

