/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.automation.fluent.models.PrivateLinkResourceInner;
import com.azure.resourcemanager.automation.implementation.PrivateLinkResourceImpl;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.PrivateLinkResource;
import com.azure.resourcemanager.automation.models.PrivateLinkResources;

public final class PrivateLinkResourcesImpl
implements PrivateLinkResources {
    private static final ClientLogger LOGGER = new ClientLogger(PrivateLinkResourcesImpl.class);
    private final PrivateLinkResourcesClient innerClient;
    private final AutomationManager serviceManager;

    public PrivateLinkResourcesImpl(PrivateLinkResourcesClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PrivateLinkResource> automation(String resourceGroupName, String automationAccountName) {
        PagedIterable<PrivateLinkResourceInner> inner = this.serviceClient().automation(resourceGroupName, automationAccountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PrivateLinkResource> automation(String resourceGroupName, String automationAccountName, Context context) {
        PagedIterable<PrivateLinkResourceInner> inner = this.serviceClient().automation(resourceGroupName, automationAccountName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)((Object)inner1), this.manager()));
    }

    private PrivateLinkResourcesClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }
}

