/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.Python2PackagesClient;
import com.azure.resourcemanager.automation.fluent.models.ModuleInner;
import com.azure.resourcemanager.automation.implementation.ModuleImpl;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.Module;
import com.azure.resourcemanager.automation.models.Python2Packages;

public final class Python2PackagesImpl
implements Python2Packages {
    private static final ClientLogger LOGGER = new ClientLogger(Python2PackagesImpl.class);
    private final Python2PackagesClient innerClient;
    private final AutomationManager serviceManager;

    public Python2PackagesImpl(Python2PackagesClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String automationAccountName, String packageName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, automationAccountName, packageName, context);
    }

    @Override
    public void delete(String resourceGroupName, String automationAccountName, String packageName) {
        this.serviceClient().delete(resourceGroupName, automationAccountName, packageName);
    }

    @Override
    public Response<Module> getWithResponse(String resourceGroupName, String automationAccountName, String packageName, Context context) {
        Response<ModuleInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, packageName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ModuleImpl((ModuleInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Module get(String resourceGroupName, String automationAccountName, String packageName) {
        ModuleInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, packageName);
        if (inner != null) {
            return new ModuleImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Module> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        PagedIterable<ModuleInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ModuleImpl((ModuleInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Module> listByAutomationAccount(String resourceGroupName, String automationAccountName, Context context) {
        PagedIterable<ModuleInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ModuleImpl((ModuleInner)((Object)inner1), this.manager()));
    }

    @Override
    public Module getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String packageName = ResourceManagerUtils.getValueFromIdByName(id, "python2Packages");
        if (packageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'python2Packages'.", id)));
        }
        return (Module)this.getWithResponse(resourceGroupName, automationAccountName, packageName, Context.NONE).getValue();
    }

    @Override
    public Response<Module> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String packageName = ResourceManagerUtils.getValueFromIdByName(id, "python2Packages");
        if (packageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'python2Packages'.", id)));
        }
        return this.getWithResponse(resourceGroupName, automationAccountName, packageName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String packageName = ResourceManagerUtils.getValueFromIdByName(id, "python2Packages");
        if (packageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'python2Packages'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, automationAccountName, packageName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String packageName = ResourceManagerUtils.getValueFromIdByName(id, "python2Packages");
        if (packageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'python2Packages'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, automationAccountName, packageName, context);
    }

    private Python2PackagesClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ModuleImpl define(String name) {
        return new ModuleImpl(name, this.manager());
    }
}

