/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automation.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.automation.fluent.models.GraphicalRunbookContentInner;
import com.azure.resourcemanager.automation.implementation.AutomationClientImpl;
import reactor.core.publisher.Mono;

public final class ResourceProvidersClientImpl
implements ResourceProvidersClient {
    private final ResourceProvidersService service;
    private final AutomationClientImpl client;

    ResourceProvidersClientImpl(AutomationClientImpl client) {
        this.service = (ResourceProvidersService)RestProxy.create(ResourceProvidersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GraphicalRunbookContentInner>> convertGraphRunbookContentWithResponseAsync(String resourceGroupName, String automationAccountName, GraphicalRunbookContentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-06-22";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.convertGraphRunbookContent(this.client.getEndpoint(), resourceGroupName, automationAccountName, this.client.getSubscriptionId(), "2021-06-22", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GraphicalRunbookContentInner>> convertGraphRunbookContentWithResponseAsync(String resourceGroupName, String automationAccountName, GraphicalRunbookContentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2021-06-22";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.convertGraphRunbookContent(this.client.getEndpoint(), resourceGroupName, automationAccountName, this.client.getSubscriptionId(), "2021-06-22", parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GraphicalRunbookContentInner> convertGraphRunbookContentAsync(String resourceGroupName, String automationAccountName, GraphicalRunbookContentInner parameters) {
        return this.convertGraphRunbookContentWithResponseAsync(resourceGroupName, automationAccountName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((GraphicalRunbookContentInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GraphicalRunbookContentInner> convertGraphRunbookContentWithResponse(String resourceGroupName, String automationAccountName, GraphicalRunbookContentInner parameters, Context context) {
        return (Response)this.convertGraphRunbookContentWithResponseAsync(resourceGroupName, automationAccountName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GraphicalRunbookContentInner convertGraphRunbookContent(String resourceGroupName, String automationAccountName, GraphicalRunbookContentInner parameters) {
        return (GraphicalRunbookContentInner)this.convertGraphRunbookContentWithResponse(resourceGroupName, automationAccountName, parameters, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomationClientReso")
    public static interface ResourceProvidersService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/convertGraphRunbookContent")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GraphicalRunbookContentInner>> convertGraphRunbookContent(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") GraphicalRunbookContentInner var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

