/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.automation.fluent.models.GraphicalRunbookContentInner;
import com.azure.resourcemanager.automation.implementation.GraphicalRunbookContentImpl;
import com.azure.resourcemanager.automation.models.GraphicalRunbookContent;
import com.azure.resourcemanager.automation.models.ResourceProviders;

public final class ResourceProvidersImpl
implements ResourceProviders {
    private static final ClientLogger LOGGER = new ClientLogger(ResourceProvidersImpl.class);
    private final ResourceProvidersClient innerClient;
    private final AutomationManager serviceManager;

    public ResourceProvidersImpl(ResourceProvidersClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<GraphicalRunbookContent> convertGraphRunbookContentWithResponse(String resourceGroupName, String automationAccountName, GraphicalRunbookContentInner parameters, Context context) {
        Response<GraphicalRunbookContentInner> inner = this.serviceClient().convertGraphRunbookContentWithResponse(resourceGroupName, automationAccountName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GraphicalRunbookContentImpl((GraphicalRunbookContentInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public GraphicalRunbookContent convertGraphRunbookContent(String resourceGroupName, String automationAccountName, GraphicalRunbookContentInner parameters) {
        GraphicalRunbookContentInner inner = this.serviceClient().convertGraphRunbookContent(resourceGroupName, automationAccountName, parameters);
        if (inner != null) {
            return new GraphicalRunbookContentImpl(inner, this.manager());
        }
        return null;
    }

    private ResourceProvidersClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }
}

