/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automation.fluent.RunbookDraftsClient;
import com.azure.resourcemanager.automation.fluent.models.RunbookDraftInner;
import com.azure.resourcemanager.automation.fluent.models.RunbookDraftUndoEditResultInner;
import com.azure.resourcemanager.automation.implementation.AutomationClientImpl;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class RunbookDraftsClientImpl
implements RunbookDraftsClient {
    private final RunbookDraftsService service;
    private final AutomationClientImpl client;

    RunbookDraftsClientImpl(AutomationClientImpl client) {
        this.service = (RunbookDraftsService)RestProxy.create(RunbookDraftsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getContentWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "text/powershell";
        return FluxUtil.withContext(context -> this.service.getContent(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "text/powershell", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getContentWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "text/powershell";
        context = this.client.mergeContext(context);
        return this.service.getContent(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "text/powershell", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Flux<ByteBuffer>> getContentAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        return this.getContentWithResponseAsync(resourceGroupName, automationAccountName, runbookName).flatMap(res -> Mono.justOrEmpty((Object)((Flux)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Flux<ByteBuffer>> getContentWithResponse(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        return (Response)this.getContentWithResponseAsync(resourceGroupName, automationAccountName, runbookName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> getContent(String resourceGroupName, String automationAccountName, String runbookName) {
        return (Flux)this.getContentWithResponse(resourceGroupName, automationAccountName, runbookName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> replaceContentWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, Flux<ByteBuffer> runbookContent, long contentLength) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        if (runbookContent == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookContent is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.replaceContent(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", runbookContent, contentLength, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> replaceContentWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, Flux<ByteBuffer> runbookContent, long contentLength, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        if (runbookContent == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookContent is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.replaceContent(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", runbookContent, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BinaryData>, BinaryData> beginReplaceContentAsync(String resourceGroupName, String automationAccountName, String runbookName, Flux<ByteBuffer> runbookContent, long contentLength) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.replaceContentWithResponseAsync(resourceGroupName, automationAccountName, runbookName, runbookContent, contentLength);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BinaryData.class), (Type)((Object)BinaryData.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BinaryData>, BinaryData> beginReplaceContentAsync(String resourceGroupName, String automationAccountName, String runbookName, Flux<ByteBuffer> runbookContent, long contentLength, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.replaceContentWithResponseAsync(resourceGroupName, automationAccountName, runbookName, runbookContent, contentLength, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BinaryData.class), (Type)((Object)BinaryData.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BinaryData> replaceContentAsync(String resourceGroupName, String automationAccountName, String runbookName, Flux<ByteBuffer> runbookContent, long contentLength) {
        return this.beginReplaceContentAsync(resourceGroupName, automationAccountName, runbookName, runbookContent, contentLength).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BinaryData> replaceContentAsync(String resourceGroupName, String automationAccountName, String runbookName, Flux<ByteBuffer> runbookContent, long contentLength, Context context) {
        return this.beginReplaceContentAsync(resourceGroupName, automationAccountName, runbookName, runbookContent, contentLength, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData replaceContent(String resourceGroupName, String automationAccountName, String runbookName, Flux<ByteBuffer> runbookContent, long contentLength) {
        return (BinaryData)this.replaceContentAsync(resourceGroupName, automationAccountName, runbookName, runbookContent, contentLength).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData replaceContent(String resourceGroupName, String automationAccountName, String runbookName, Flux<ByteBuffer> runbookContent, long contentLength, Context context) {
        return (BinaryData)this.replaceContentAsync(resourceGroupName, automationAccountName, runbookName, runbookContent, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> replaceContentWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, BinaryData runbookContent, long contentLength) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        if (runbookContent == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookContent is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.replaceContent(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", runbookContent, contentLength, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> replaceContentWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, BinaryData runbookContent, long contentLength, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        if (runbookContent == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookContent is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.replaceContent(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", runbookContent, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BinaryData>, BinaryData> beginReplaceContentAsync(String resourceGroupName, String automationAccountName, String runbookName, BinaryData runbookContent, long contentLength) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.replaceContentWithResponseAsync(resourceGroupName, automationAccountName, runbookName, runbookContent, contentLength);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BinaryData.class), (Type)((Object)BinaryData.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BinaryData>, BinaryData> beginReplaceContentAsync(String resourceGroupName, String automationAccountName, String runbookName, BinaryData runbookContent, long contentLength, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.replaceContentWithResponseAsync(resourceGroupName, automationAccountName, runbookName, runbookContent, contentLength, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BinaryData.class), (Type)((Object)BinaryData.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BinaryData>, BinaryData> beginReplaceContent(String resourceGroupName, String automationAccountName, String runbookName, BinaryData runbookContent, long contentLength) {
        return this.beginReplaceContentAsync(resourceGroupName, automationAccountName, runbookName, runbookContent, contentLength).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BinaryData>, BinaryData> beginReplaceContent(String resourceGroupName, String automationAccountName, String runbookName, BinaryData runbookContent, long contentLength, Context context) {
        return this.beginReplaceContentAsync(resourceGroupName, automationAccountName, runbookName, runbookContent, contentLength, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BinaryData> replaceContentAsync(String resourceGroupName, String automationAccountName, String runbookName, BinaryData runbookContent, long contentLength) {
        return this.beginReplaceContentAsync(resourceGroupName, automationAccountName, runbookName, runbookContent, contentLength).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BinaryData> replaceContentAsync(String resourceGroupName, String automationAccountName, String runbookName, BinaryData runbookContent, long contentLength, Context context) {
        return this.beginReplaceContentAsync(resourceGroupName, automationAccountName, runbookName, runbookContent, contentLength, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData replaceContent(String resourceGroupName, String automationAccountName, String runbookName, BinaryData runbookContent, long contentLength) {
        return (BinaryData)this.replaceContentAsync(resourceGroupName, automationAccountName, runbookName, runbookContent, contentLength).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData replaceContent(String resourceGroupName, String automationAccountName, String runbookName, BinaryData runbookContent, long contentLength, Context context) {
        return (BinaryData)this.replaceContentAsync(resourceGroupName, automationAccountName, runbookName, runbookContent, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RunbookDraftInner>> getWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RunbookDraftInner>> getWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RunbookDraftInner> getAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        return this.getWithResponseAsync(resourceGroupName, automationAccountName, runbookName).flatMap(res -> Mono.justOrEmpty((Object)((RunbookDraftInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RunbookDraftInner> getWithResponse(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, automationAccountName, runbookName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RunbookDraftInner get(String resourceGroupName, String automationAccountName, String runbookName) {
        return (RunbookDraftInner)this.getWithResponse(resourceGroupName, automationAccountName, runbookName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RunbookDraftUndoEditResultInner>> undoEditWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.undoEdit(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RunbookDraftUndoEditResultInner>> undoEditWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.undoEdit(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RunbookDraftUndoEditResultInner> undoEditAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        return this.undoEditWithResponseAsync(resourceGroupName, automationAccountName, runbookName).flatMap(res -> Mono.justOrEmpty((Object)((RunbookDraftUndoEditResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RunbookDraftUndoEditResultInner> undoEditWithResponse(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        return (Response)this.undoEditWithResponseAsync(resourceGroupName, automationAccountName, runbookName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RunbookDraftUndoEditResultInner undoEdit(String resourceGroupName, String automationAccountName, String runbookName) {
        return (RunbookDraftUndoEditResultInner)this.undoEditWithResponse(resourceGroupName, automationAccountName, runbookName, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomationClientRunb")
    public static interface RunbookDraftsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/content")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> getContent(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="runbookName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: text/powershell"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/content")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> replaceContent(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="runbookName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="text/powershell") Flux<ByteBuffer> var7, @HeaderParam(value="Content-Length") long var8, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: text/powershell"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/content")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> replaceContent(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="runbookName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="text/powershell") BinaryData var7, @HeaderParam(value="Content-Length") long var8, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RunbookDraftInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="runbookName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/undoEdit")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RunbookDraftUndoEditResultInner>> undoEdit(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="runbookName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

